// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Config.h                                                                                                   ==
// ==                 ========                                                                                                   ==
// ==          Zweck: Ermittelt und Speichert die Konfiguration                                                                  ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#ifndef	__CONFIG_H__
#define __CONFIG_H__

// ================================================================================================================================
// Makros
#define	TN_CONFIGVERSION			1											// Die bentigte Konfigurationsversion

// ================================================================================================================================
// Die Konfigurationsstruktur
struct SConfig
{
	WORD			wConfigVersion;												// Die Version der Konfiguration

	char			acNagiosUrl[256];											// Die Url ins Hauptverzeichnis von Nagios
	char			acNagiosCgiUrl[256];										// Die Url ins cgi-bin Verzeichnis von Nagios

	BOOL			bCheckAutomatically;										// Automatisches Prfen
	DWORD			dwCheckInterval;											// Prfintervall in Sekunden

	BOOL			bAuthRequired;												// Sollen wir uns authorisieren?
	char			acAuthName[64];												// Der Authentifikationsname
	char			acAuthPassword[64];											// Das Authentifikationspasswort

	BOOL			abAlertPopups[4];											// Popups sind erlaubt
	BOOL			abAlertSounds[4];											// Sounds sind erlaubt
	BOOL			abAlertCommands[4];											// Kommandozeilenbefehl

	char			acAlertCommand[4][256];										// Der Kommandozeilenbefehl

	char			acLanguage[32];												// Die Sprache

	BOOL			bVersionCheck;												// Versionscheck
};

// ================================================================================================================================
// Funktionen
EResult				DoConfigDlg(SConfig* pInOut);								// Ermittelt eine Konfiguration
EResult				LoadConfig(SConfig* pOut);									// Ldt die Konfiguration
EResult				SaveConfig(SConfig* pIn);									// Speichert die Konfiguration

#endif