// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: GUI.h                                                                                                      ==
// ==                 =====                                                                                                      ==
// ==          Zweck: Verwaltet die Windowsoberflche                                                                            ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#ifndef	__GUI_H__
#define __GUI_H__

// ================================================================================================================================
// Makros
#define		ER_INFO(x)							{ TN_GUI->ProtocolOut(x, 0); }				// Eine Infomeldung im Protokoll
#define		ER_OK(x)							{ TN_GUI->ProtocolOut(x, 2); TN_GUI->SwitchIcon(EI_OK); TN_GUI->SetTipText(GetString(IDS_TIP_OK)); if(TN_MAIN.GetLastStatus() != 0) { if(TN_MAIN.GetConfig()->abAlertPopups[0]) /* Popups sind erlaubt */ DoPopup(x, 0); if(TN_MAIN.GetConfig()->abAlertSounds[0]) /*Sounds sind erlaubt */ PlaySound("OK.wav", TN_MAIN.GetProgramInstance(), SND_ASYNC); TN_MAIN.SetStatus(0); } }					// Eine OK-Meldung im Protokoll
#define		ER_ERROR(x)							{ TN_GUI->ProtocolOut(x, 1); TN_GUI->SwitchIcon(EI_ERROR); TN_GUI->SetTipText(GetString(IDS_TIP_ERROR)); if(TN_MAIN.GetLastStatus() != 3) { if(TN_MAIN.GetConfig()->abAlertPopups[3]) /* Popups sind erlaubt */ DoPopup(x, 3); if(TN_MAIN.GetConfig()->abAlertSounds[3]) /* Sounds sind erlaubt */ PlaySound("Alert.wav", TN_MAIN.GetProgramInstance(), SND_ASYNC); TN_MAIN.SetStatus(3); } }		// Eine Fehlermeldung
#define		ER_WARNING(x)						{ TN_GUI->ProtocolOut(x, 3); TN_GUI->SwitchIcon(EI_WARNING); TN_GUI->SetTipText(GetString(IDS_TIP_WARNING)); if(TN_MAIN.GetLastStatus() != 2) { if(TN_MAIN.GetConfig()->abAlertPopups[2]) /* Popups sind erlaubt */ DoPopup(x, 2); if(TN_MAIN.GetConfig()->abAlertSounds[2]) /* Sounds sind erlaubt */ PlaySound("Warning.wav", TN_MAIN.GetProgramInstance(), SND_ASYNC); TN_MAIN.SetStatus(2); } }	// Eine Warnung
#define		ER_UNKNOWN(x)						{ TN_GUI->ProtocolOut(x, 4); TN_GUI->SwitchIcon(EI_UNKNOWN); TN_GUI->SetTipText(GetString(IDS_TIP_UNKNOWN)); if(TN_MAIN.GetLastStatus() != 1) { if(TN_MAIN.GetConfig()->abAlertPopups[1]) /* Popups sind erlaubt */ DoPopup(x, 1); if(TN_MAIN.GetConfig()->abAlertSounds[1]) /* Sounds sind erlaubt */ PlaySound("Unknown.wav", TN_MAIN.GetProgramInstance(), SND_ASYNC); TN_MAIN.SetStatus(1); } }	// Unbekannt

#define		WM_WINSOCK							(WM_USER+1)									// WinSock meldet sich
#define		WM_TRAYICON							(WM_USER+2)									// Das TrayIcon sendet Nachricht
#define		WM_TRAYICON_OPEN					(WM_USER+3)									// TrayIcon -> ffnen
#define		WM_TRAYICON_NAGIOS					(WM_USER+4)									// TrayIcon -> Nagios ffnen
#define		WM_TRAYICON_CHECK					(WM_USER+5)									// TrayIcon -> Prfen
#define		WM_TRAYICON_CONFIG					(WM_USER+6)									// TrayIcon -> Einstellungen
#define		WM_TRAYICON_EXIT					(WM_USER+7)									// TrayIcon -> Beenden

#define		WM_MENU_PROGRAM_NAGIOS				(WM_TRAYICON_NAGIOS)						// Programm -> Nagios ffnen
#define		WM_MENU_PROGRAM_CHECK				(WM_TRAYICON_CHECK)							// Programm -> Prfen
#define		WM_MENU_PROGRAM_CONFIG				(WM_TRAYICON_CONFIG)						// Programm -> Einstellungen
#define		WM_MENU_PROGRAM_TRAY				(WM_USER+8)									// Programm -> Verstecken
#define		WM_MENU_PROGRAM_EXIT				(WM_TRAYICON_EXIT)							// Programm -> Beenden

#define		WM_MENU_QUESTION_INFO				(WM_USER+9)									// ? -> Info
#define		WM_MENU_QUESTION_HELP				(WM_USER+10)								// ? -> Hilfe

#define		WM_MENU_DEBUG_OK					(WM_USER+11)								// Debugmen -> OK
#define		WM_MENU_DEBUG_UNKNOWN				(WM_USER+12)								// Debugmen -> Unbekannt
#define		WM_MENU_DEBUG_WARNING				(WM_USER+13)								// Debugmen -> Warnung
#define		WM_MENU_DEBUG_ERROR					(WM_USER+14)								// Debugmen -> Fehler

#define		TN_WINDOWCLASS						("TraiedNagiosWindowClass:Seku.info")		// Fensterklassenname fr Hauptfenster

// ================================================================================================================================
// Die Icons
enum EIcons
{
	EI_UNKNOWN			= 0,																// Das neutrale Icon
	EI_OK				= 1,																// Das Alles OK!-Icon
	EI_WARNING			= 2,																// Das Warnung-Icon
	EI_ERROR			= 3,																// Das Fehler-Icon
	EI_NONE				= 4																	// Nichts
};

// ================================================================================================================================
// Die GUIKlasse
class CGUI
{
	private:
		// Private Variablen
		BOOL			m_bInitialized;														// Kann die Klasse genutzt werden?
		HINSTANCE		m_hInstance;														// Die Programminstanz

		BOOL			m_bTraied;															// Ist das Fenster getrayt?
		EIcons			m_CurrentIcon;														// Das aktuelle Icon
		char			m_acTip[64];														// Der Drberfahrtext

		HWND			m_hMainWindow;														// Das Hauptfenster
		HWND			m_hHosts;															// Die Hosttabelle
		HWND			m_hServices;														// Die Servicestabelle
		HWND			m_hProtocol;														// Das Protokollfenster

		HICON			m_hIcons[4];														// Die Icons

		HMENU			m_hPopupMenu;														// Das PopupMen
		HMENU			m_hMenu;															// Das Men des Hauptfensters
		HMENU			m_hMenuProgram;														// Das Men -> Programm
		HMENU			m_hMenuQuestion;													// Das Men -> ?
		HMENU			m_hMenuDebug;														// In der Debugversion gibt es noch ein Men

		HMODULE			m_hLanguageLibrary;													// Die Sprachbibliothek

	public:
		// Konstruktor und Destruktor
		CGUI()			{ ZeroMemory(this, sizeof(CGUI)); }									// Der Konstruktor
		~CGUI()			{ if(m_bInitialized) Exit(); }										// Der Destruktor

		// Methoden
		EResult			Init(HINSTANCE hInstance);											// Initialisiert
		EResult			MainLoop();															// Die Fensterschleife
		EResult			DoWindowProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam);	// Die Fensterfunktion
		EResult			Exit();																// Deinitialisiert

		EResult			Tray(BOOL bTray, EIcons NewIcon = EI_NONE);							// Trayt/Detrayt das Fenster
		EResult			SwitchIcon(EIcons NewIcon);											// Wechselt das TrayIcon
		EResult			SetTipText(char* pcNewTip);											// ndert den TrayTipText

		EResult			ProtocolOut(char* pcString, BYTE Color = 0);						// Gibt etwas im Protokoll aus

		// Inlinemethoden
		BOOL			IsInitialized() { return m_bInitialized; }							// Ist die Klasse initialisiert?
		HWND			GetMainWindow() { return m_hMainWindow; }							// Gibt das Handle auf das Hauptfenster zurck
		HWND			GetHostWindow() { return m_hHosts; }								// Gibt das Handle auf die Hosttabelle zurck
		HWND			GetServiceWindow() { return m_hServices; }							// Gibt das Handle auf die Servicetabelle zurck
		HMODULE			GetLanguageLibrary() { return m_hLanguageLibrary; }					// Gibt die Sprachbibliothek zurck
};

#endif