// ===============================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Network.h                                                                                                  ==
// ==                 =========                                                                                                  ==
// ==          Zweck: Schnittstelle zu WinSock                                                                                   ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#ifndef	__NETWORK_H__
#define __NETWORK_H__

// ================================================================================================================================
// Die Netzwerkklasse
class CNetwork
{
	private:
		// Private Variablen
		BOOL			m_bInitialized;																		// Initialisiert
		BOOL			m_bConnected;																		// Sind wir konnektiert
		SOCKET			m_Socket;																			// Der Socket

	public:
		// Konstruktor und Destruktor
		CNetwork()		{ ZeroMemory(this, sizeof(CNetwork)); }												// Der Konstruktor
		~CNetwork()		{ if(m_bInitialized) Exit(); }														// Der Destruktor

		// ffentliche Methoden
		EResult			Init();																				// Initialisiert
		EResult			Start(char* pcUrl);																	// Startet eine Verbindung
		EResult			End();																				// Schliet die Verbindung
		EResult			Exit();																				// Deinitialisiert

		// Inlinemethoden
		BOOL			IsConnected() { return m_bConnected; }												// Sind wir konnektiert?
		SOCKET			GetSocket() { return m_Socket; }													// Gibt den Socket zurck
};

#endif