// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Config.cpp                                                                                                 ==
// ==                 ==========                                                                                                 ==
// ==          Zweck: Ermittelt und Speichert die Konfiguration                                                                  ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Globale Variablen
SConfig*		g_pIn;			// Fr den Konfigurationsdialog
SConfig*		g_pOut;			// Fr den Konfigurationsdialog
HWND			g_hChilds[5];	// Die untergeordneten Fenster

// ================================================================================================================================
// Die Dialogfunktion der Verbindungseinstellungen
int CALLBACK ConnectionDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Das Fenster wird erstellt; Werte eintragen
			if(g_pIn)
			{
				// Die URLs
				SetDlgItemText(hWindow, ID_URL, g_pIn->acNagiosUrl);
				SetDlgItemText(hWindow, ID_CGI_URL, g_pIn->acNagiosCgiUrl);

				// Die Authentifizierungsfelder
				CheckDlgButton(hWindow, ID_AUTH, g_pIn->bAuthRequired);
				SetDlgItemText(hWindow, ID_AUTH_NAME, g_pIn->acAuthName);
				SetDlgItemText(hWindow, ID_AUTH_PASSWORD, g_pIn->acAuthPassword);
				EnableWindow(GetDlgItem(hWindow, ID_AUTH_NAME), g_pIn->bAuthRequired);
				EnableWindow(GetDlgItem(hWindow, ID_AUTH_PASSWORD), g_pIn->bAuthRequired);
			}

			// Spracheinstellungen
			SetDlgItemText(hWindow, ID_FRAME_URLS,				GetString(IDS_CONFIG_FRAME_URLS));
			SetDlgItemText(hWindow, ID_FRAME_AUTH,				GetString(IDS_CONFIG_FRAME_AUTH));
			SetDlgItemText(hWindow, ID_MAINDIR,					GetString(IDS_CONFIG_MAINDIR));
			SetDlgItemText(hWindow, ID_CGIDIR,					GetString(IDS_CONFIG_CGIDIR));
			SetDlgItemText(hWindow, ID_AUTH,					GetString(IDS_CONFIG_ACTIVATE));
			SetDlgItemText(hWindow, ID_NAME,					GetString(IDS_CONFIG_NAME));
			SetDlgItemText(hWindow, ID_PASSWORD,				GetString(IDS_CONFIG_PASSWORD));
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde bettigt
			switch(LOWORD(WParam))
			{
				case ID_AUTH:
					// Die Eingabefeld fr .htaccess-PW-Schutz de-/aktivieren
					EnableWindow(GetDlgItem(hWindow, ID_AUTH_NAME), IsDlgButtonChecked(hWindow, ID_AUTH) == BST_CHECKED);
					EnableWindow(GetDlgItem(hWindow, ID_AUTH_PASSWORD), IsDlgButtonChecked(hWindow, ID_AUTH) == BST_CHECKED);
					break;
			}
			break;

		case WM_CLOSE:
			// Ende
			EndDialog(hWindow, 1);
			break;
	}

	// Nachricht an Windows weiterleiten
	return FALSE;
}

// ================================================================================================================================
// Die Dialogfunktion der Fehlerbenachrichtigungseinstellungen
int CALLBACK ErrorMessagingDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Das Fenster wird erstellt; Werte eintragen
			if(g_pIn)
			{
				CheckDlgButton(hWindow, ID_POPUP_OK, g_pIn->abAlertPopups[0] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_POPUP_UNKNOWN, g_pIn->abAlertPopups[1] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_POPUP_WARNING, g_pIn->abAlertPopups[2] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_POPUP_ERROR, g_pIn->abAlertPopups[3] ? BST_CHECKED : BST_UNCHECKED);

				CheckDlgButton(hWindow, ID_SOUND_OK, g_pIn->abAlertSounds[0] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_SOUND_UNKNOWN, g_pIn->abAlertSounds[1] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_SOUND_WARNING, g_pIn->abAlertSounds[2] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_SOUND_ERROR, g_pIn->abAlertSounds[3] ? BST_CHECKED : BST_UNCHECKED);

				CheckDlgButton(hWindow, ID_COMMAND_OK, g_pIn->abAlertCommands[0] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_COMMAND_UNKNOWN, g_pIn->abAlertCommands[1] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_COMMAND_WARNING, g_pIn->abAlertCommands[2] ? BST_CHECKED : BST_UNCHECKED);
				CheckDlgButton(hWindow, ID_COMMAND_ERROR, g_pIn->abAlertCommands[3] ? BST_CHECKED : BST_UNCHECKED);

				EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_OK), g_pIn->abAlertCommands[0]);
				EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_UNKNOWN), g_pIn->abAlertCommands[1]);
				EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_WARNING), g_pIn->abAlertCommands[2]);
				EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_ERROR), g_pIn->abAlertCommands[3]);

				SetDlgItemText(hWindow, ID_COMMANDLINE_OK, g_pIn->acAlertCommand[0]);
				SetDlgItemText(hWindow, ID_COMMANDLINE_UNKNOWN, g_pIn->acAlertCommand[1]);
				SetDlgItemText(hWindow, ID_COMMANDLINE_WARNING, g_pIn->acAlertCommand[2]);
				SetDlgItemText(hWindow, ID_COMMANDLINE_ERROR, g_pIn->acAlertCommand[3]);
			}

			// Spracheinstellungen
			SetDlgItemText(hWindow, ID_FRAME_ERRORMESSAGING,	GetString(IDS_CONFIG_FRAME_ERRORMESSAGING));
			SetDlgItemText(hWindow, ID_FRAME_COMMANDLINES,		GetString(IDS_CONFIG_FRAME_COMMANDLINES));
			
			SetDlgItemText(hWindow, ID_OK,						GetString(IDS_CONFIG_OK));
			SetDlgItemText(hWindow, ID_UNKNOWN,					GetString(IDS_CONFIG_UNKNOWN));
			SetDlgItemText(hWindow, ID_WARNING,					GetString(IDS_CONFIG_WARNING));
			SetDlgItemText(hWindow, ID_ERROR,					GetString(IDS_CONFIG_ERROR));

			SetDlgItemText(hWindow, ID_OK2,						GetString(IDS_CONFIG_OK));
			SetDlgItemText(hWindow, ID_UNKNOWN2,				GetString(IDS_CONFIG_UNKNOWN));
			SetDlgItemText(hWindow, ID_WARNING2,				GetString(IDS_CONFIG_WARNING));
			SetDlgItemText(hWindow, ID_ERROR2,					GetString(IDS_CONFIG_ERROR));

			SetDlgItemText(hWindow, ID_SOUND,					GetString(IDS_CONFIG_SOUND));
			SetDlgItemText(hWindow, ID_POPUP,					GetString(IDS_CONFIG_POPUP));
			SetDlgItemText(hWindow, ID_COMMANDLINE,				GetString(IDS_CONFIG_COMMANDLINE));
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde bettigt
			switch(LOWORD(WParam))
			{
				case ID_COMMAND_OK:
					// Kommandozeile fr Status 'OK' wurde de-/aktiviert
					EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_OK), IsDlgButtonChecked(hWindow, ID_COMMAND_OK) == BST_CHECKED);
					break;

				case ID_COMMAND_UNKNOWN:
					// Kommandozeile fr Status 'Unbekannt' wurde de-/aktiviert
					EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_UNKNOWN), IsDlgButtonChecked(hWindow, ID_COMMAND_UNKNOWN) == BST_CHECKED);
					break;

				case ID_COMMAND_WARNING:
					// Kommandozeile fr Status 'Warnung' wurde de-/aktiviert
					EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_WARNING), IsDlgButtonChecked(hWindow, ID_COMMAND_WARNING) == BST_CHECKED);
					break;

				case ID_COMMAND_ERROR:
					// Kommandozeile fr Status 'Fehler' wurde de-/aktiviert
					EnableWindow(GetDlgItem(hWindow, ID_COMMANDLINE_ERROR), IsDlgButtonChecked(hWindow, ID_COMMAND_ERROR) == BST_CHECKED);
					break;
			}
			break;

		case WM_CLOSE:
			// Das Fenster wird beendet
			EndDialog(hWindow, 1);
			break;
	}

	// Nachricht an Windows weiterleiten
	return FALSE;
}

// ================================================================================================================================
// Die Dialogfunktion der Prfeinstellungen
int CALLBACK CheckDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Das Fenster wird erstellt; Werte eintragen
			if(g_pIn)
			{
				CheckDlgButton(hWindow, ID_AUTOMATIC_CHECK, g_pIn->bCheckAutomatically ? BST_CHECKED : BST_UNCHECKED);
				char acTemp[16];	sprintf(acTemp, "%d", g_pIn->dwCheckInterval);
				SetDlgItemText(hWindow, ID_CHECK_INTERVAL, acTemp);
				EnableWindow(GetDlgItem(hWindow, ID_CHECK_INTERVAL), g_pIn->bCheckAutomatically);
			}

			// Spracheinstellungen
			SetDlgItemText(hWindow, ID_FRAME_AUTOMATICCHECK,	GetString(IDS_CONFIG_FRAME_AUTOMATICCHECK));
			SetDlgItemText(hWindow, ID_AUTOMATIC_CHECK,			GetString(IDS_CONFIG_ACTIVATE));
			SetDlgItemText(hWindow, ID_INTERVAL,				GetString(IDS_CONFIG_INTERVAL));
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde bettigt
			switch(LOWORD(WParam))
			{
				case ID_AUTOMATIC_CHECK:
					// Das Eingabefeld de-/aktivieren
					EnableWindow(GetDlgItem(hWindow, ID_CHECK_INTERVAL), IsDlgButtonChecked(hWindow, ID_AUTOMATIC_CHECK) == BST_CHECKED);
					break;
			}
			break;

		case WM_CLOSE:
			// Das Fenster wird beendet
			EndDialog(hWindow, 1);
			break;
	}

	// Nachricht an Windows weiterleiten
	return FALSE;
}

// ================================================================================================================================
// Die Dialogfunktion der anderen Einstellungen
int CALLBACK MiscDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Das Fenster wird erstellt; Werte eintragen
			if(g_pIn)
			{
				CheckDlgButton(hWindow, ID_VERSIONCHECK, g_pIn->bVersionCheck ? BST_CHECKED : BST_UNCHECKED);
			}

			// Spracheinstellungen
			SetDlgItemText(hWindow, ID_FRAME_AUTOMATICUPDATES,	GetString(IDS_CONFIG_FRAME_AUTOMATICUPDATES));
			SetDlgItemText(hWindow, ID_VERSIONCHECK,			GetString(IDS_CONFIG_VERSIONCHECK));
			break;

		case WM_CLOSE:
			// Das Fenster wird beendet
			EndDialog(hWindow, 1);
			break;
	}

	// Nachricht an Windows weiterleiten
	return FALSE;
}

// ================================================================================================================================
// Die Dialogfunktion der Spracheinstellungen
int CALLBACK LanguageDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	WIN32_FIND_DATA	FindData;	// Fr FindFirst, FindNext
	HANDLE			hFind;		// Das Handle fr die Suche

	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Das Fenster wird erstellt; Sprachen eintragen
			SendDlgItemMessage(hWindow, ID_LANGUAGE, CB_ADDSTRING, 0, (LPARAM)GetString(IDS_LANGUAGE, TRUE));

			// Ersten Eintrag auswhlen
			SendDlgItemMessage(hWindow, ID_LANGUAGE, CB_SETCURSEL, 0, 0);

			// Alle Sprachen aus DLLs einladen
			hFind = FindFirstFile("*.dll", &FindData);
			if(hFind != INVALID_HANDLE_VALUE)
			{
				// Es wurde was gefunden, wir gehen alle durch und tragen sie ein
				do
				{
					// Eintragen
					int iIndex = SendDlgItemMessage(hWindow, ID_LANGUAGE, CB_ADDSTRING, 0, (LPARAM)FindData.cFileName);

					// Ist das der Eintrag, der ausgewhlten Sprache?
					if(g_pIn && strcmp(g_pIn->acLanguage, FindData.cFileName) == 0)
					{
						// Ja! Auswhlen
						SendDlgItemMessage(hWindow, ID_LANGUAGE, CB_SETCURSEL, (WPARAM)iIndex, 0);
					}
				} while(FindNextFile(hFind, &FindData));
			}

			// Spracheinstellungen
			SetDlgItemText(hWindow, ID_FRAME_LANGUAGE,	GetString(IDS_CONFIG_FRAME_LANGUAGE));
			SetDlgItemText(hWindow, ID_SELECTLANGUAGE,	GetString(IDS_CONFIG_SELECTLANGUAGE));
			break;

		case WM_CLOSE:
			// Das Fenster wird beendet
			EndDialog(hWindow, 1);
			break;
	}

	// Nachricht an Windows weiterleiten
	return FALSE;
}

// ================================================================================================================================
// Die Dialogfunktion
int CALLBACK ConfigDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	int		iWindow;
	char	acTemp[256];
	int		iIndex;
	char*	pcData;
	int		iResult;

	// Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Der Dialog wird erstellt; Zentrieren
			RECT Rect;
			GetWindowRect(hWindow, &Rect);
			SetWindowPos(hWindow, 0, GetSystemMetrics(SM_CXSCREEN)/2 - Rect.right/2,
									 GetSystemMetrics(SM_CYSCREEN)/2 - Rect.bottom/2,
									 Rect.right,
									 Rect.bottom, 0);

			// Das Men links fllen
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_CONFIG_CONNECTION));
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_CONFIG_ERRORMESSAGING));
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_CONFIG_CHECK));
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_CONFIG_LANGUAGE));
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_CONFIG_MISC));
			SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_SETCURSEL, 0, 0);

			// Wir erstenn die Fenster
			g_hChilds[0] = CreateDialog(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG_CONNECTION), hWindow, ConnectionDlgProc);
			g_hChilds[1] = CreateDialog(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG_ERRORMESSAGING), hWindow, ErrorMessagingDlgProc);
			g_hChilds[2] = CreateDialog(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG_CHECK), hWindow, CheckDlgProc);
			g_hChilds[3] = CreateDialog(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG_LANGUAGE), hWindow, LanguageDlgProc);
			g_hChilds[4] = CreateDialog(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG_MISC), hWindow, MiscDlgProc);

			// Alle Fenster richtig verschieben
			for(iWindow = 0; iWindow < 5; iWindow++)
			{
				// Verschieben
				BringWindowToTop(g_hChilds[iWindow]);
				MoveWindow(g_hChilds[iWindow], 160, 0, 470, 300, TRUE);
				ShowWindow(g_hChilds[iWindow], SW_HIDE);
			}

			// Das erste Fenster sichtbar machen
			ShowWindow(g_hChilds[0], SW_SHOW);

			// Spracheinstellungen
			SetWindowText( hWindow,					GetString(IDS_CONFIG_TITLE));
			SetDlgItemText(hWindow, ID_RESETCONFIG,	GetString(IDS_CONFIG_RESET));
			SetDlgItemText(hWindow, ID_SUBMIT,		GetString(IDS_CONFIG_SUBMIT));
			SetDlgItemText(hWindow, ID_CANCEL,		GetString(IDS_CONFIG_CANCEL));
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde gedrckt; welches
			switch(LOWORD(WParam))
			{
				case ID_SUBMIT:
					// Jemand hat auf den OK-Button gedrckt
					// Das Fenster wird beendet. Einstellungen speichern
					// Die URLs
					GetDlgItemText(g_hChilds[0], ID_URL, acTemp, 256);
					strcpy(g_pOut->acNagiosUrl, acTemp);
					GetDlgItemText(g_hChilds[0], ID_CGI_URL, acTemp, 256);
					strcpy(g_pOut->acNagiosCgiUrl, acTemp);

					// Die HTTP Authentifizierungsdaten
					g_pOut->bAuthRequired = IsDlgButtonChecked(g_hChilds[0], ID_AUTH) == BST_CHECKED;
					GetDlgItemText(g_hChilds[0], ID_AUTH_NAME, acTemp, 64);
					strcpy(g_pOut->acAuthName, acTemp);
					GetDlgItemText(g_hChilds[0], ID_AUTH_PASSWORD, acTemp, 64);
					strcpy(g_pOut->acAuthPassword, acTemp);

					// Die Felder der Fehlerbenachrichtigung
					g_pOut->abAlertPopups[0] = IsDlgButtonChecked(g_hChilds[1], ID_POPUP_OK) == BST_CHECKED;
					g_pOut->abAlertPopups[1] = IsDlgButtonChecked(g_hChilds[1], ID_POPUP_UNKNOWN) == BST_CHECKED;
					g_pOut->abAlertPopups[2] = IsDlgButtonChecked(g_hChilds[1], ID_POPUP_WARNING) == BST_CHECKED;
					g_pOut->abAlertPopups[3] = IsDlgButtonChecked(g_hChilds[1], ID_POPUP_ERROR) == BST_CHECKED;

					g_pOut->abAlertSounds[0] = IsDlgButtonChecked(g_hChilds[1], ID_SOUND_OK) == BST_CHECKED;
					g_pOut->abAlertSounds[1] = IsDlgButtonChecked(g_hChilds[1], ID_SOUND_UNKNOWN) == BST_CHECKED;
					g_pOut->abAlertSounds[2] = IsDlgButtonChecked(g_hChilds[1], ID_SOUND_WARNING) == BST_CHECKED;
					g_pOut->abAlertSounds[3] = IsDlgButtonChecked(g_hChilds[1], ID_SOUND_ERROR) == BST_CHECKED;

					g_pOut->abAlertCommands[0] = IsDlgButtonChecked(g_hChilds[1], ID_COMMAND_OK) == BST_CHECKED;
					g_pOut->abAlertCommands[1] = IsDlgButtonChecked(g_hChilds[1], ID_COMMAND_UNKNOWN) == BST_CHECKED;
					g_pOut->abAlertCommands[2] = IsDlgButtonChecked(g_hChilds[1], ID_COMMAND_WARNING) == BST_CHECKED;
					g_pOut->abAlertCommands[3] = IsDlgButtonChecked(g_hChilds[1], ID_COMMAND_ERROR) == BST_CHECKED;

					// Die Kommandozeilen
					GetDlgItemText(g_hChilds[1], ID_COMMANDLINE_OK, acTemp, 256);
					strcpy(g_pOut->acAlertCommand[0], acTemp);

					GetDlgItemText(g_hChilds[1], ID_COMMANDLINE_UNKNOWN, acTemp, 256);
					strcpy(g_pOut->acAlertCommand[1], acTemp);

					GetDlgItemText(g_hChilds[1], ID_COMMANDLINE_WARNING, acTemp, 256);
					strcpy(g_pOut->acAlertCommand[2], acTemp);

					GetDlgItemText(g_hChilds[1], ID_COMMANDLINE_ERROR, acTemp, 256);
					strcpy(g_pOut->acAlertCommand[3], acTemp);

					// Die Fenster des Automatischen Prfens
					g_pOut->bCheckAutomatically = IsDlgButtonChecked(g_hChilds[2], ID_AUTOMATIC_CHECK) == BST_CHECKED;
					GetDlgItemText(g_hChilds[2], ID_CHECK_INTERVAL, acTemp, 64); g_pOut->dwCheckInterval = atoi(acTemp);

					// Die Sprache
					iIndex = (int)SendDlgItemMessage(g_hChilds[3], ID_LANGUAGE, CB_GETCURSEL, 0, 0);
					pcData = (char*)malloc(SendDlgItemMessage(g_hChilds[3], ID_LANGUAGE, CB_GETLBTEXTLEN, (WPARAM)iIndex, 0) * sizeof(char));
					iResult = (int)SendDlgItemMessage(g_hChilds[3], ID_LANGUAGE, CB_GETLBTEXT, (WPARAM)iIndex, (LPARAM)pcData);
					if(iResult == (int)CB_ERR || strcmp(pcData, "Deutsch") == 0)
						strcpy(g_pOut->acLanguage, "");									// Deutsch
					else
						memcpy(g_pOut->acLanguage, (char*)pcData, 32 * sizeof(char));	// Andere Sprache -> Speichern

					// Der Versionscheck
					g_pOut->bVersionCheck = IsDlgButtonChecked(g_hChilds[4], ID_VERSIONCHECK) == BST_CHECKED;

					// Ende
					EndDialog(hWindow, 1);
					break;

				case ID_RESETCONFIG:
					// Die Einstellungen zurcksetzen
					CheckDlgButton(g_hChilds[1], ID_POPUP_OK, BST_CHECKED);
					CheckDlgButton(g_hChilds[1], ID_POPUP_UNKNOWN, BST_CHECKED);
					CheckDlgButton(g_hChilds[1], ID_POPUP_WARNING, BST_CHECKED);
					CheckDlgButton(g_hChilds[1], ID_POPUP_ERROR, BST_CHECKED);

					CheckDlgButton(g_hChilds[1], ID_SOUND_OK, BST_CHECKED);
					CheckDlgButton(g_hChilds[1], ID_SOUND_UNKNOWN,BST_UNCHECKED);
					CheckDlgButton(g_hChilds[1], ID_SOUND_WARNING, BST_CHECKED);
					CheckDlgButton(g_hChilds[1], ID_SOUND_ERROR, BST_CHECKED);

					CheckDlgButton(g_hChilds[1], ID_COMMAND_OK, BST_UNCHECKED);
					CheckDlgButton(g_hChilds[1], ID_COMMAND_UNKNOWN, BST_UNCHECKED);
					CheckDlgButton(g_hChilds[1], ID_COMMAND_WARNING, BST_UNCHECKED);
					CheckDlgButton(g_hChilds[1], ID_COMMAND_ERROR, BST_UNCHECKED);

					SetDlgItemText(g_hChilds[1], ID_COMMANDLINE_OK, "");
					SetDlgItemText(g_hChilds[1], ID_COMMANDLINE_UNKNOWN, "");
					SetDlgItemText(g_hChilds[1], ID_COMMANDLINE_WARNING, "");
					SetDlgItemText(g_hChilds[1], ID_COMMANDLINE_ERROR, "");

					EnableWindow(GetDlgItem(g_hChilds[1], ID_COMMANDLINE_OK), FALSE);
					EnableWindow(GetDlgItem(g_hChilds[1], ID_COMMANDLINE_UNKNOWN), FALSE);
					EnableWindow(GetDlgItem(g_hChilds[1], ID_COMMANDLINE_WARNING), FALSE);
					EnableWindow(GetDlgItem(g_hChilds[1], ID_COMMANDLINE_ERROR), FALSE);

					CheckDlgButton(g_hChilds[2], ID_AUTOMATIC_CHECK, BST_CHECKED);
					sprintf(acTemp, "%d", 45);
					SetDlgItemText(g_hChilds[2], ID_CHECK_INTERVAL, acTemp);
					EnableWindow(GetDlgItem(g_hChilds[2], ID_CHECK_INTERVAL), TRUE);

					CheckDlgButton(g_hChilds[4], ID_VERSIONCHECK, BST_CHECKED);
					break;

				case ID_CANCEL:
					// Abbrechen
					EndDialog(hWindow, 0);
					break;
			}

			// Es kann noch das Auswahlfenster sein
			if(HIWORD(WParam) == LBN_SELCHANGE && (HWND)LParam == GetDlgItem(hWindow, ID_CONFIGLIST))
			{
				// Sie ist es
				// Im Auswahlfenster wurde ein anderes Item ausgewhlt
				int iIndex = (int)SendDlgItemMessage(hWindow, ID_CONFIGLIST, LB_GETCURSEL, 0, 0);
				if(iIndex == (int)CB_ERR) break;	// Fehler

				// Wir whlen das Fenster aus. Dafr machen wir alle anderen unsichtbar
				for(iWindow = 0; iWindow < 5; iWindow++)
					ShowWindow(g_hChilds[iWindow], SW_HIDE);

				// Und zeigen das neue an
				ShowWindow(g_hChilds[iIndex], SW_SHOW);
			}
			break;

		case WM_CLOSE:
			// Der Dialog wird beendet
			EndDialog(hWindow, 1);
			break;
	}

	// Alles OK, Wir leiten die Nachricht an Windows weiter
	return FALSE;
}

// ================================================================================================================================
// Ermittelt eine Konfiguration
EResult DoConfigDlg(SConfig* pInOut)
{
	// Pointer prfen
	if(!pInOut) return ER_INVALID_CALL;

	// Wir globalisieren die alte Konfigurationsstruktur und starten dann den Dialog
	g_pIn = pInOut;
	g_pOut = pInOut;

	// Wir starten den Dialog
	DialogBox(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_DIALOG_CONFIG), NULL, ConfigDlgProc);

	// Wir haben die neuste Konfigurationsversion
	g_pOut->wConfigVersion = TN_CONFIGVERSION;

	// Eventuell mssen wir den automatischen Check-Timer erstellen / lschen / ndern
	if(TN_GUI->IsInitialized())
	{
		if(g_pOut->bCheckAutomatically)
		{
			// Wir erstellen ihn neu
			KillTimer(TN_GUI->GetMainWindow(), 2);
			SetTimer(TN_GUI->GetMainWindow(), 2, g_pOut->dwCheckInterval * 1000, NULL);
		}
		else
		{
			// Wir lschen ihn
			KillTimer(TN_GUI->GetMainWindow(), 2);
		}
	}

	// Sollen Sounds ausgegeben werden?
	BOOL bFileError = FALSE;
	if(g_pOut->abAlertSounds[0])
	{
		FILE* pFile = fopen("OK.wav", "r");
		if(!pFile) bFileError = TRUE;
		else fclose(pFile);
	}

	if(g_pOut->abAlertSounds[1])
	{
		FILE* pFile = fopen("Unknown.wav", "r");
		if(!pFile) bFileError = TRUE;
		else fclose(pFile);
	}

	if(g_pOut->abAlertSounds[2])
	{
		FILE* pFile = fopen("Warning.wav", "r");
		if(!pFile) bFileError = TRUE;
		else fclose(pFile);
	}

	if(g_pOut->abAlertSounds[3])
	{
		FILE* pFile = fopen("Alert.wav", "r");
		if(!pFile) bFileError = TRUE;
		else fclose(pFile);
	}

	// Ausgabe
	if(bFileError)
		MessageBox(NULL, GetString(IDS_SOUNDSMISSING), GetString(IDS_HINWEIS), MB_OK | MB_ICONEXCLAMATION);

	// Wir speichern die Konfiguration
	SaveConfig(g_pOut);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Ldt die Konfiguration
EResult LoadConfig(SConfig* pOut)
{
	FILE* pFile;

	// Pointer prfen
	if(!pOut) return ER_INVALID_CALL;

	// Wir ffnen die Datei
	pFile = fopen("Config.tnc", "rb");
	if(!pFile) return ER_NOT_FOUND;

	// Wir lesen die Konfiguration
	if(fread(pOut, sizeof(SConfig), 1, pFile) != 1)
	{
		// Fehler!
		fclose(pFile);
		return ER_ERROR;
	}

	// Wir schlieen die Datei wieder
	fclose(pFile);

	// Wenn die Konfigurationsversion nicht die erwartete ist, wird sie nicht geladen
	if(pOut->wConfigVersion != TN_CONFIGVERSION)
	{
		// Neu die Konfiguration abfragen
		ZeroMemory(pOut, sizeof(SConfig));
		pOut->wConfigVersion		= 1;
		pOut->bCheckAutomatically	= TRUE;
		pOut->dwCheckInterval		= 45;
		pOut->bAuthRequired			= FALSE;
		strcpy(pOut->acNagiosUrl,	  TN_DEFINITION_SERVER);
		strcpy(pOut->acNagiosCgiUrl, TN_DEFINITION_SERVER_CGI);
		pOut->abAlertPopups[0]		= TRUE;
		pOut->abAlertPopups[1]		= TRUE;
		pOut->abAlertPopups[2]		= TRUE;
		pOut->abAlertPopups[3]		= TRUE;

		pOut->abAlertSounds[0]		= TRUE;
		pOut->abAlertSounds[2]		= TRUE;
		pOut->abAlertSounds[3]		= TRUE;

		strcpy(pOut->acLanguage, "");

		pOut->bVersionCheck			= TRUE;
		DoConfigDlg(pOut);
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Speichert die Konfiguration
EResult SaveConfig(SConfig* pIn)
{
	FILE* pFile;

	// Pointer prfen
	if(!pIn) return ER_INVALID_CALL;

	// Wir ffnen die Datei
	pFile = fopen("Config.tnc", "wb");
	if(!pFile) return ER_NOT_FOUND;

	// Wir schreiben die Konfiguration
	if(fwrite(pIn, sizeof(SConfig), 1, pFile) != 1)
	{
		// Fehler!
		fclose(pFile);
		return ER_ERROR;
	}

	// Wir schlieen die Datei wieder
	fclose(pFile);

	// Alles OK!
	return ER_OK;
}