// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: GUI.cpp                                                                                                    ==
// ==                 =======                                                                                                    ==
// ==          Zweck: Verwaltet die Windowsoberflche                                                                            ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Die Fensterfunktion
LRESULT CALLBACK WindowProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Wir verarbeiten die Nachricht
	if(TN_MAIN.DoWindowProc(hWindow, uiMsg, WParam, LParam))
		return TRUE;											// Fehler
	else
		return DefWindowProc(hWindow, uiMsg, WParam, LParam);	// OK: Nachricht an Windows weitergeben
}

// ================================================================================================================================
// Initialisiert
EResult CGUI::Init(HINSTANCE hInstance)
{
	WNDCLASSEX	WindowClass;

	// Damit man die Instanz mehrmals nutzen kann
	Exit();

	// Wir speichern die Instanz
	m_hInstance = hInstance;

	// Bentigen wir eine Sprachbibliothek?
	if(strcmp(TN_MAIN.GetConfig()->acLanguage, "") != 0)
	{
		// Ja, laden
		m_hLanguageLibrary = LoadLibrary(TN_MAIN.GetConfig()->acLanguage);
		if(m_hLanguageLibrary == NULL) strcpy(TN_MAIN.GetConfig()->acLanguage, "");		// Fehler!
	}

	// Wir laden die Icons
	m_hIcons[EI_UNKNOWN]	= LoadIcon(m_hInstance, MAKEINTRESOURCE(ID_ICON_NORMAL));
	m_hIcons[EI_OK]			= LoadIcon(m_hInstance, MAKEINTRESOURCE(ID_ICON_OK));
	m_hIcons[EI_WARNING]	= LoadIcon(m_hInstance, MAKEINTRESOURCE(ID_ICON_WARNING));
	m_hIcons[EI_ERROR]		= LoadIcon(m_hInstance, MAKEINTRESOURCE(ID_ICON_ERROR));

	
	// Wir erstellen das PopupMen
	m_hPopupMenu = CreatePopupMenu();
	AppendMenu(m_hPopupMenu,	MF_STRING,		WM_TRAYICON_OPEN,					GetString(IDS_MENU_OPEN));
	AppendMenu(m_hPopupMenu,	MF_STRING,		WM_TRAYICON_NAGIOS,					GetString(IDS_MENU_BROWSER));
	AppendMenu(m_hPopupMenu,	MF_STRING,		WM_TRAYICON_CHECK,					GetString(IDS_MENU_CHECK));
	AppendMenu(m_hPopupMenu,	MF_SEPARATOR,	0,									NULL);
	AppendMenu(m_hPopupMenu,	MF_STRING,		WM_TRAYICON_CONFIG,					GetString(IDS_MENU_CONFIG));
	AppendMenu(m_hPopupMenu,	MF_STRING,		WM_TRAYICON_EXIT,					GetString(IDS_MENU_EXIT));

	// Wir erstellen das Fenster, dazu brauchen wir die Fensterklasse
	ZeroMemory(&WindowClass, sizeof(WNDCLASSEX));
	WindowClass.cbSize			= sizeof(WNDCLASSEX);
	WindowClass.style			= CS_CLASSDC;
	WindowClass.lpfnWndProc		= WindowProc;
	WindowClass.cbClsExtra		= 0;
	WindowClass.cbWndExtra		= 0;
	WindowClass.hInstance		= m_hInstance;
	WindowClass.hIcon			= m_hIcons[EI_UNKNOWN];
	WindowClass.hIconSm			= WindowClass.hIcon;
	WindowClass.hCursor			= LoadCursor(m_hInstance, IDC_ARROW);
	WindowClass.hbrBackground	= (HBRUSH)GetSysColorBrush(COLOR_3DFACE);
	WindowClass.lpszMenuName	= NULL;
	WindowClass.lpszClassName	= TN_WINDOWCLASS;

	// Wir registrieren die Fensterklasse
	if(!RegisterClassEx(&WindowClass)) return ER_ERROR;

	// Wir erstellen das Fenster
	m_hMainWindow = CreateWindow(TN_WINDOWCLASS,
								 "Traied Nagios",
								 WS_OVERLAPPEDWINDOW | WS_VISIBLE,
								 GetSystemMetrics(SM_CXSCREEN)/2 - 300/2,
								 GetSystemMetrics(SM_CYSCREEN)/2 - 250/2,
								 300,
								 250,
								 NULL,
								 NULL,
								 m_hInstance,
								 NULL);
	if(!m_hMainWindow) return ER_ERROR;
	ShowWindow(m_hMainWindow, SW_HIDE);

	// Wir erstellen das Men
	m_hMenuProgram = CreatePopupMenu();
	AppendMenu(m_hMenuProgram,	MF_STRING,		WM_MENU_PROGRAM_NAGIOS,				GetString(IDS_MENU_BROWSER));
	AppendMenu(m_hMenuProgram,	MF_STRING,		WM_MENU_PROGRAM_CHECK,				GetString(IDS_MENU_CHECK));
	AppendMenu(m_hMenuProgram,	MF_SEPARATOR,	0,									NULL);
	AppendMenu(m_hMenuProgram,	MF_STRING,		WM_MENU_PROGRAM_CONFIG,				GetString(IDS_MENU_CONFIG));
	AppendMenu(m_hMenuProgram,	MF_STRING,		WM_MENU_PROGRAM_TRAY,				GetString(IDS_MENU_TRAY));
	AppendMenu(m_hMenuProgram,	MF_STRING,		WM_MENU_PROGRAM_EXIT,				GetString(IDS_MENU_EXIT));

	m_hMenuQuestion = CreatePopupMenu();
	AppendMenu(m_hMenuQuestion,	MF_STRING,		WM_MENU_QUESTION_INFO,				GetString(IDS_MENU_INFO));
	AppendMenu(m_hMenuQuestion,	MF_STRING,		WM_MENU_QUESTION_HELP,				GetString(IDS_MENU_HELP));

	m_hMenuDebug = CreatePopupMenu();
	AppendMenu(m_hMenuDebug,	MF_STRING,		WM_MENU_DEBUG_OK,					"Fehlermeldung: &OK");
	AppendMenu(m_hMenuDebug,	MF_STRING,		WM_MENU_DEBUG_UNKNOWN,				"Fehlermeldung: &Unbekannt");
	AppendMenu(m_hMenuDebug,	MF_STRING,		WM_MENU_DEBUG_WARNING,				"Fehlermeldung: &Warnung");
	AppendMenu(m_hMenuDebug,	MF_STRING,		WM_MENU_DEBUG_ERROR,				"Fehlermeldung: &Ausfall");

	m_hMenu = CreateMenu();
	AppendMenu(m_hMenu,			MF_POPUP,		(unsigned int)m_hMenuProgram,		GetString(IDS_PROGRAM));
	AppendMenu(m_hMenu,			MF_STRING,		WM_MENU_PROGRAM_CHECK,				GetString(IDS_MENU_CHECK));
#ifdef _DEBUG
	// In der Debugversion gibt es noch ein Men
	AppendMenu(m_hMenu,			MF_POPUP,		(unsigned int)m_hMenuDebug,			"&Debug");
#endif
	AppendMenu(m_hMenu,			MF_POPUP,		(unsigned int)m_hMenuQuestion,		GetString(IDS_MENU_QUESTION));
	SetMenu(m_hMainWindow, m_hMenu);

	// Wir erstellen die Hosttabelle
	RECT Rect;
	GetClientRect(m_hMainWindow, &Rect);
	m_hHosts = CreateWindowEx(WS_EX_CLIENTEDGE,
							  "LISTBOX",
							  "Hosts",
							  LBS_NOINTEGRALHEIGHT | WS_VSCROLL | WS_CHILD | WS_VISIBLE,
							  0, 0,
							  Rect.right/2, Rect.bottom - 100 + 10,
							  m_hMainWindow,
							  NULL,
							  m_hInstance,
							  NULL);
	if(!m_hHosts) return ER_ERROR;

	// Wir erstellen die Servicestabelle
	m_hServices = CreateWindowEx(WS_EX_CLIENTEDGE,
								 "LISTBOX",
								 "Services",
								 LBS_NOINTEGRALHEIGHT | WS_VSCROLL | WS_CHILD | WS_VISIBLE,
								 Rect.right/2, 0,
								 Rect.right/2, Rect.bottom - 100 + 10,
								 m_hMainWindow,
								 NULL,
								 m_hInstance,
								 NULL);
	if(!m_hHosts) return ER_ERROR;

	// Die Schriften setzen
	SendMessage(m_hServices, WM_SETFONT, (WPARAM)GetStockObject(DEFAULT_GUI_FONT), 0);
	SendMessage(m_hHosts, WM_SETFONT, (WPARAM)GetStockObject(DEFAULT_GUI_FONT), 0);

	// Wir erstellen das Protokollfeld
	if(!LoadLibrary("Riched20.dll"))
	{
		MessageBox(m_hMainWindow, GetString(IDS_NORICHEDIT), GetString(IDS_ERROR), MB_OK | MB_ICONERROR);
		return ER_ERROR;
	}
	m_hProtocol = CreateWindowEx(WS_EX_CLIENTEDGE,
								 RICHEDIT_CLASS,
								 "",
								 ES_MULTILINE | ES_READONLY | WS_VSCROLL | WS_CHILD | WS_VISIBLE,
								 0, Rect.bottom - 100+10,
								 Rect.right, 100,
								 m_hMainWindow,
								 NULL,
								 m_hInstance,
								 NULL);
	if(!m_hProtocol) return ER_ERROR;

	// Das Schriftformat des Protokollfeldes setzen
	CHARFORMAT CharFormat;
	CharFormat.cbSize		= sizeof(CHARFORMAT);
	CharFormat.dwMask		= CFM_FACE | CFM_SIZE;
	CharFormat.yHeight		= 160;
	strcpy(CharFormat.szFaceName, "Arial");
	SendMessage(m_hProtocol, EM_SETCHARFORMAT, SCF_ALL, (LPARAM)&CharFormat);

	// Der Starttext
	ER_INFO(GetString(IDS_PROTOCOLINIT));
	SendMessage(m_hHosts, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_ALLHOSTS2));
	SendMessage(m_hHosts, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_HOSTSUP2));
	SendMessage(m_hHosts, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_HOSTSDOWN2));
	SendMessage(m_hHosts, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_HOSTSUNREACHABLE2));
	SendMessage(m_hHosts, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_HOSTSPENDING2));

	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_ALLSERVICES2));
	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_SERVICESUP2));
	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_SERVICESWARNING2));
	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_SERVICESUNKNOWN2));
	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_SERVICESCRITICAL2));
	SendMessage(m_hServices, LB_ADDSTRING, 0, (LPARAM)GetString(IDS_SERVICESPENDING2));

	// Wir trayen das Fenster
	strcpy(m_acTip, GetString(IDS_TIP_UNKNOWN));
	m_CurrentIcon = EI_UNKNOWN;
	Tray(TRUE);

	// Wir passen die Elementgre nochmal an
	GetClientRect(m_hMainWindow, &Rect);
	SetWindowPos(m_hHosts, 0, 0, 0, Rect.right/2, Rect.bottom - 100 + 10, 0);
	SetWindowPos(m_hServices, 0, Rect.right/2, 0, Rect.right/2, Rect.bottom - 100 + 10, 0);
	SetWindowPos(m_hProtocol, 0, 0, Rect.bottom - 100+10, Rect.right, 100-10, 0);

	// Alles OK!
#ifdef _DEBUG
	ShowWindow(m_hMainWindow, SW_SHOW);
#endif
	m_bInitialized = TRUE;
	return ER_OK;
}

// ================================================================================================================================
// Die Fensterschleife
EResult CGUI::MainLoop()
{
	MSG Message;

	// Wir starten die Fensterschleife
	ZeroMemory(&Message, sizeof(MSG));
	while(GetMessage(&Message, 0, 0, 0))
	{
		// bersetzen und Weiterleiten
		TranslateMessage(&Message);
		DispatchMessage(&Message);
		if(Message.message == WM_QUIT)
			break;	// Fenster wurde beendet
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Die Fensterfunktion
EResult CGUI::DoWindowProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Wir verarbeiten die Nachricht
	switch(uiMsg)
	{
		case WM_CREATE:
			// Das Fenster wird erstellt
			break;

		case WM_TIMER:
			// Welcher Timer?
			if(WParam == 1)
			{
				// TimeOut
				ER_ERROR(GetString(IDS_TIMEOUT));
				KillTimer(hWindow, 1);
			}
			else
			{
				// Automatischer Check
				TN_MAIN.Check(FALSE);
			}
			break;

		case WM_WINSOCK:
			// WinSock meldet sich
			switch(LOWORD(LParam))
			{
				case FD_READ:
					// Wir empfangen
					TN_MAIN.Check2();
					break;
			}
			break;

		case WM_TRAYICON:
			// Das TrayIcon sendet eine Nachricht
			if(LParam == WM_LBUTTONUP)
			{
				// Linke Maustaste wurde gedrckt -> Konsole ffnen
				ShowWindow(hWindow, SW_SHOW);
				SetForegroundWindow(hWindow);
			}
			else if(LParam == WM_RBUTTONUP)
			{
				// Rechte Maustaste wurde gedrckt -> Men ffnen
				POINT Cursor;
				GetCursorPos(&Cursor);

				SetForegroundWindow(hWindow);
				TrackPopupMenu(m_hPopupMenu, TPM_LEFTALIGN, Cursor.x, Cursor.y, 0, hWindow, NULL);
			}
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde bettigt
			switch(LOWORD(WParam))
			{
				case WM_MENU_PROGRAM_TRAY:
					// Trayen
					ShowWindow(hWindow, SW_HIDE);
					break;

				case WM_MENU_QUESTION_INFO:
					// Wir rufen den Infodialog aus
					DoInfoDlg();
					break;

				case WM_MENU_QUESTION_HELP:
					// Wir rufen die Hilfedatei auf
					if(ShellExecute(hWindow, "open", GetString(IDS_HELPFILENAME), NULL, NULL, SW_SHOW) == (HINSTANCE)ERROR_FILE_NOT_FOUND)
					{
						// Die Datei wurde nicht gefunden, sollen wir sie downloaden?
						if(MessageBox(hWindow, GetString(IDS_NOHELPFILE), GetString(IDS_ERROR), MB_YESNO | MB_ICONQUESTION) == IDYES)
						{
							// Ja - Downloaden
							if(DownloadHelpFile() != ER_OK) { MessageBox(hWindow, GetString(IDS_HELPFILEDOWNLOADERR), GetString(IDS_ERROR), MB_OK | MB_ICONERROR); break; }
							if(ShellExecute(hWindow, "open", GetString(IDS_HELPFILENAME), NULL, NULL, SW_SHOW) <= (HINSTANCE)32)
							{
								// Fehler!
								MessageBox(hWindow, GetString(IDS_HELPFILEERR), GetString(IDS_ERROR), MB_OK | MB_ICONERROR);
							}
						}
					}
					break;

				case WM_MENU_DEBUG_OK:
					// Debug - Unbekannt
					TN_MAIN.DebugOK();
					TN_MAIN.Check(FALSE);
					break;

				case WM_MENU_DEBUG_UNKNOWN:
					// Debug - Unbekannt
					TN_MAIN.DebugUnknown();
					TN_MAIN.Check(FALSE);
					break;

				case WM_MENU_DEBUG_WARNING:
					// Debug - Warnung
					TN_MAIN.DebugWarning();
					TN_MAIN.Check(FALSE);
					break;

				case WM_MENU_DEBUG_ERROR:
					// Debug - Fehler
					TN_MAIN.DebugError();
					TN_MAIN.Check(FALSE);
					break;

				case WM_TRAYICON_OPEN:
					// Konsole ffnen
					ShowWindow(hWindow, SW_SHOW);
					SetForegroundWindow(hWindow);
					break;

				case WM_TRAYICON_NAGIOS:
					// Browser ffnen
					OpenURL(TN_MAIN.GetConfig()->acNagiosUrl);
					break;

				case WM_TRAYICON_CHECK:
					// Prfen
					TN_MAIN.Check(TRUE);
					break;

				case WM_TRAYICON_CONFIG:
					// Den Konfigurationsdialog starten
					DoConfigDlg(TN_MAIN.GetConfig());
					break;

				case WM_TRAYICON_EXIT:
					// Programm beenden
					PostQuitMessage(1);
					break;
			}
			break;

		case WM_SIZE:
			// Das Fenster wird verzerrt, wir mssen die Felder anpassen
			RECT Rect;
			GetClientRect(m_hMainWindow, &Rect);
			SetWindowPos(m_hHosts, 0, 0, 0, Rect.right/2, Rect.bottom - 100 + 10, 0);
			SetWindowPos(m_hServices, 0, Rect.right/2, 0, Rect.right/2, Rect.bottom - 100 + 10, 0);
			SetWindowPos(m_hProtocol, 0, 0, Rect.bottom - 100+10, Rect.right, 100-10, 0);
			break;

		case WM_CLOSE:
			// Wir schlieen das Programm nicht, wir trayen es
			ShowWindow(hWindow, SW_HIDE);
			return ER_ERROR;
			break;

		case WM_SYSCOMMAND:
			if(WParam == SC_MINIMIZE)
			{
				// Das Fenster soll minimiert werden. Wir trayen es jedoch
				ShowWindow(hWindow, SW_HIDE);
				return ER_ERROR;
			}
			break;

		case WM_DESTROY:
			// Fenster beenden
			PostQuitMessage(1);
			break;
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Gibt etwas im Protokoll aus
EResult CGUI::ProtocolOut(char* pcString, BYTE Color)
{
	GETTEXTLENGTHEX		GetTextLength;
	CHARRANGE			CharRange;
	unsigned int		uiTextLength;
	SYSTEMTIME			SystemTime;
	char*				pcText;

	// Spreicher reservieren
	pcText = new char[strlen(pcString) * sizeof(char) + 32];

	// Den neuen Text richtig ermitteln
	GetLocalTime(&SystemTime);
	sprintf(pcText, "[%d-%d-%d %d:%d] %s\n", SystemTime.wDay, SystemTime.wMonth, SystemTime.wYear, SystemTime.wHour, SystemTime.wMinute, pcString);

	// Wir ermitteln die bisherige Textlnge
	GetTextLength.flags = GTL_NUMCHARS;
	uiTextLength = (unsigned int)SendMessage(m_hProtocol, EM_GETTEXTLENGTHEX, (WPARAM)&GetTextLength, 0);

	// Wir markieren das letzte Zeichen
	CharRange.cpMin = uiTextLength;
	CharRange.cpMax = uiTextLength + 1;
	SendMessage(m_hProtocol, EM_EXSETSEL, 0, (LPARAM)&CharRange);

	// Jetzt knnen wir den neuen setzen
	SendMessage(m_hProtocol, EM_REPLACESEL, (WPARAM)FALSE, (LPARAM)pcText);

	// Wir markieren jetzt den neu hinzugefgten Text
	CharRange.cpMin = uiTextLength;
	CharRange.cpMax = uiTextLength + strlen(pcText);
	SendMessage(m_hProtocol, EM_EXSETSEL, 0, (LPARAM)&CharRange);

	// Wir stellen die Konfiguration ein
	CHARFORMAT CharFormat;
	ZeroMemory(&CharFormat, sizeof(CHARFORMAT));
	CharFormat.cbSize		= sizeof(CHARFORMAT);
	CharFormat.dwMask		= CFM_BOLD | CFM_ITALIC | CFM_UNDERLINE | CFM_COLOR;
	CharFormat.dwEffects	= 0;
	if(Color == 1)		CharFormat.crTextColor	= RGB(154, 0,   0);
	else if(Color == 2) CharFormat.crTextColor	= RGB(0,   154, 0);
	else if(Color == 3)	CharFormat.crTextColor	= RGB(255, 102, 0);
	else if(Color == 4) CharFormat.crTextColor	= RGB(90,  90,  90);
	else				CharFormat.crTextColor	= RGB(0,   0,   0);
	SendMessage(m_hProtocol, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&CharFormat);

	// Wir scrollen ganz runter
	SendMessage(m_hProtocol, EM_SCROLL, (WPARAM)SB_PAGEDOWN, 0);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Trayt / Detrayt das Fenster
EResult CGUI::Tray(BOOL bTray, EIcons NewIcon)
{
	NOTIFYICONDATA	NotifyIconData;

	// Den neuen Zustand speichern
	if(NewIcon != EI_NONE) m_CurrentIcon = NewIcon;
	m_bTraied = bTray;
	if(m_bTraied)
	{
		// Wir trayen das Fenster
		NotifyIconData.cbSize			= sizeof(NOTIFYICONDATA);
		NotifyIconData.uID				= ID_ICON_NORMAL;
		NotifyIconData.hWnd				= m_hMainWindow;
		NotifyIconData.uFlags			= NIF_ICON | NIF_MESSAGE | NIF_TIP;
		NotifyIconData.hIcon			= m_hIcons[m_CurrentIcon];
		NotifyIconData.uCallbackMessage	= WM_TRAYICON;
		strcpy(NotifyIconData.szTip, m_acTip);

		Shell_NotifyIcon(NIM_ADD, &NotifyIconData);
		ShowWindow(m_hMainWindow, SW_HIDE);
	}
	else
	{
		// Wir detrayen das Fenster
		NotifyIconData.cbSize			= sizeof(NOTIFYICONDATA);
		NotifyIconData.uID				= ID_ICON_NORMAL;
		NotifyIconData.hWnd				= m_hMainWindow;
		NotifyIconData.uFlags			= 0;
		Shell_NotifyIcon(NIM_DELETE, &NotifyIconData);
		ShowWindow(m_hMainWindow, SW_SHOW);
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Wechselt das TrayIcon
EResult CGUI::SwitchIcon(EIcons NewIcon)
{
	NOTIFYICONDATA	NotifyIconData;

	// Neues Icon speichern
	m_CurrentIcon = NewIcon;

	// Wenn das Fenster bereits getrayt ist, mssen wir das Icon auch dort ndern
	if(m_bTraied)
	{
		// Wir setzen es beim TrayIcon
		NotifyIconData.cbSize			= sizeof(NOTIFYICONDATA);
		NotifyIconData.uID				= ID_ICON_NORMAL;
		NotifyIconData.hWnd				= m_hMainWindow;
		NotifyIconData.uFlags			= NIF_ICON;
		NotifyIconData.hIcon			= m_hIcons[m_CurrentIcon];
		Shell_NotifyIcon(NIM_MODIFY, &NotifyIconData);
	}

	// Und beim normalen Fenster
	SetClassLong(m_hMainWindow, GCL_HICON, (LONG)m_hIcons[m_CurrentIcon]);
	SetClassLong(m_hMainWindow, GCL_HICONSM, (LONG)m_hIcons[m_CurrentIcon]);
	SendMessage(m_hMainWindow, WM_SETICON, ICON_BIG, (LPARAM)m_hIcons[m_CurrentIcon]);
	SendMessage(m_hMainWindow, WM_SETICON, ICON_SMALL, (LPARAM)m_hIcons[m_CurrentIcon]);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// ndert den TrayTipText
EResult CGUI::SetTipText(char* pcNewTip)
{
	NOTIFYICONDATA	NotifyIconData;

	// Wert prfen
	if(strlen(pcNewTip) > 64) pcNewTip[63] = '\0';	// Abbrechen

	// Neuen Tip speichern
	strcpy(m_acTip, pcNewTip);

	// Wenn das Fenster bereits getrayt ist, mssen wir den Text auch dort ndern
	if(m_bTraied)
	{
		// Wir setzen es beim TrayIcon
		NotifyIconData.cbSize			= sizeof(NOTIFYICONDATA);
		NotifyIconData.uID				= ID_ICON_NORMAL;
		NotifyIconData.hWnd				= m_hMainWindow;
		NotifyIconData.uFlags			= NIF_TIP;
		strcpy(NotifyIconData.szTip, m_acTip);
		return Shell_NotifyIcon(NIM_MODIFY, &NotifyIconData) == TRUE ? ER_OK : ER_ERROR;
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Deinitialisiert
EResult CGUI::Exit()
{
	// Mssen wir berhaupt etwas machen?
	if(m_bInitialized)
	{
		// Ja
		// Untrayen
		Tray(FALSE);

		// Schlussmeldung
		ER_INFO(GetString(IDS_ENDTIP));

		// Alle Fensterschlieen
		DestroyWindow(m_hProtocol);
		DestroyWindow(m_hHosts);
		DestroyWindow(m_hServices);
		DestroyWindow(m_hMainWindow);

		// Alle Mens lschen
		DestroyMenu(m_hPopupMenu);
		DestroyMenu(m_hMenuQuestion);
		DestroyMenu(m_hMenuDebug);
		DestroyMenu(m_hMenuProgram);
		DestroyMenu(m_hMenu);

		// Alle Icons freigeben
		DestroyIcon(m_hIcons[EI_UNKNOWN]);
		DestroyIcon(m_hIcons[EI_OK]);
		DestroyIcon(m_hIcons[EI_ERROR]);

		// Die Fensterklasse lschen
		UnregisterClass(TN_WINDOWCLASS, m_hInstance);

		// Eventuell mssen wir die Sprachbibliothek entladen
		if(strcmp(TN_MAIN.GetConfig()->acLanguage, "") != 0)
			FreeLibrary(m_hLanguageLibrary);		// Entladen

		// Wir sind deinitialisiert
		m_bInitialized = FALSE;
	}

	// Alles OK!
	return ER_OK;
}