// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Misc.cpp                                                                                                   ==
// ==                 ========                                                                                                   ==
// ==          Zweck: Stellt verschiedene Funktionen                                                                             ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Globale Variablen
static const char	acEncodeChars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

// ================================================================================================================================
// Die Fensterfunktion des Infodialogs
BOOL CALLBACK InfoDlgProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	// Die Nachricht verarbeiten
	switch(uiMsg)
	{
		case WM_INITDIALOG:
			// Der Dialog wurde soeben erstellt, wir zentrieren ihn
			RECT Rect;
			GetWindowRect(hWindow, &Rect);
			SetWindowPos(hWindow, 0, GetSystemMetrics(SM_CXSCREEN)/2 - Rect.right/2,
									 GetSystemMetrics(SM_CYSCREEN)/2 - Rect.bottom/2,
									 Rect.right,
									 Rect.bottom, 0);

			// Den Text anzeigen
			char acText[512];
#ifdef _DEBUG
			sprintf(acText, GetString(IDS_INFO_DEBUG), TN_VERSION);
#else
			sprintf(acText, GetString(IDS_INFO), TN_VERSION);
#endif
			SetDlgItemText(hWindow, ID_INFO, acText);
			break;

		case WM_COMMAND:
			// Ein Kontrollelement wurde bettigt
			switch(LOWORD(WParam))
			{
				case ID_SUBMIT:
					// Der OK-Button; Dialog beenden
					EndDialog(hWindow, 1);
					break;
			}
			break;

		case WM_CLOSE:
			// Wir beenden den Dialog
			EndDialog(hWindow, 1);
			break;
	}

	// Alles OK, wir leiten die Nachricht an Windows weiter
	return FALSE;
}

// ================================================================================================================================
// Fhrt den Infodialog aus
EResult DoInfoDlg()
{
	// Wir starten den Informationsdialog
	DialogBox(TN_MAIN.GetProgramInstance(),
			  MAKEINTRESOURCE(ID_DIALOG_INFO),
			  NULL,
			  InfoDlgProc);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Downloadet die Hilfedatei
EResult DownloadHelpFile()
{
	char acTemp[32];

	// Das Internet ffnen
	HINTERNET hInternet = InternetOpen("Microsoft Internet Explorer",
									   INTERNET_OPEN_TYPE_PRECONFIG,
									   NULL, 0, 0);
	if(!hInternet)
	{
		// Fehler!
		return ER_ERROR;
	}

	// Wir konnektieren per FTP
	HINTERNET hConnection = InternetConnect(hInternet, "seku.info", INTERNET_DEFAULT_FTP_PORT,
											"web3f2", "TraiedNagios", INTERNET_SERVICE_FTP, INTERNET_FLAG_PASSIVE, NULL);
	if(!hConnection)
	{
		// Fehler
		InternetCloseHandle(hInternet);
		return ER_ERROR;
	}

	// Datei herunterladen
	sprintf(acTemp, GetString(IDS_HELPFILENAME_ONLINE), TN_VERSION);
	if(!FtpGetFile(hConnection, acTemp, GetString(IDS_HELPFILENAME), FALSE, FILE_ATTRIBUTE_NORMAL,
				   FTP_TRANSFER_TYPE_BINARY | INTERNET_FLAG_RELOAD, 0))
	{
		// Fehler
		InternetCloseHandle(hConnection);
		InternetCloseHandle(hInternet);
		return ER_ERROR;
	}

	// Handles schlieen
	InternetCloseHandle(hConnection);
	InternetCloseHandle(hInternet);

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Prft nach neuen Updates
EResult CheckForUpdates()
{
	DWORD			dwNumBytesRead;
	DWORD			dwNumAllBytesRead = 0;
	char			acText[256];
	char*			pcBuffer;
	char*			pcTemp;

	// Das Internet ffnen
	HINTERNET hInternet = InternetOpen("Microsoft Internet Explorer",
									   INTERNET_OPEN_TYPE_PRECONFIG,
									   NULL, 0, 0);
	if(!hInternet) return ER_ERROR;

	// Die URL ffnen
	HINTERNET hUrl = InternetOpenUrl(hInternet,
									 "http://traiednagios.seku.info/version.php?check=6KYU",
									 NULL, 0, 0, 0);
	if(!hUrl) { InternetCloseHandle(hInternet); return ER_ERROR; }

	// Wir starten die Leseschleife
	pcBuffer = (char*)malloc(sizeof(char) * 64);
	pcTemp = pcBuffer;
	do
	{
		// In jedem Durchgang lesen wir 16 Bytes
		if(!InternetReadFile(hUrl, pcTemp, 16, &dwNumBytesRead))
		{
			// Fehler!
			InternetCloseHandle(hUrl);
			InternetCloseHandle(hInternet);
			return ER_ERROR;
		}

		// Den Zeiger und den Zhler weiterschieben
		dwNumAllBytesRead += dwNumBytesRead;
		pcTemp += dwNumBytesRead;
	} while(dwNumBytesRead);

	// Alles schlieen
	InternetCloseHandle(hUrl);
	InternetCloseHandle(hInternet);

	// Den String beenden
	pcBuffer[dwNumAllBytesRead] = '\0';

	// Wir prfen
	if(strcmp(pcBuffer, TN_VERSION) != 0)
	{
		// Wir haben einer veraltete Version
		sprintf(acText, GetString(IDS_OLDVERSION), TN_VERSION, pcBuffer);
		MessageBox(TN_MAIN.GetGUI()->GetMainWindow(), acText, GetString(IDS_HINWEIS), MB_OK | MB_ICONINFORMATION);
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Ladet einen String aus der Sprachtabelle
char* GetString(int iCode, BOOL bOwnLangLib)
{
	char* pcTemp = new char[256];

	// Gibt es eine Sprachbibliothek?
	if(TN_MAIN.GetGUI()->GetLanguageLibrary() && !bOwnLangLib)
	{
		// Ja. Wir benutzen sie
		if(LoadString(TN_MAIN.GetGUI()->GetLanguageLibrary(), iCode, pcTemp, 256))
			return pcTemp; // Alles OK!
	}

	// Ein Fehler trat auf, oder wir sollen wirklich Deutsch benutzen
	if(!LoadString(TN_MAIN.GetProgramInstance(), iCode, pcTemp, 256))
	{
		// Fehler!
		MessageBox(NULL, "The main language library of the program is damaged.\nPlease reinstall Traied Nagios.", "Traied Nagios", MB_OK | MB_ICONERROR);
		TN_MAIN.Exit();
		PostQuitMessage(1);
	}

	// Alles OK!
	return pcTemp;
}

// ================================================================================================================================
// ffnet eine Seite in einem NEUEN Browser
EResult OpenURL(char* pcUrl)
{
	HKEY	hKey;
	char*	pcBrowser = new char[256];
	DWORD	dwSize = 256;

	if(!pcUrl) return ER_INVALID_CALL;

	// Den Standardbrowser auslesen. Dazu ffnen wir die Registry
	if(RegOpenKeyEx(HKEY_CLASSES_ROOT, "HTTP\\shell\\open\\command", 0, KEY_READ, &hKey) != ERROR_SUCCESS)
	{
		// Fehler! Wir fhren die URL einfach so aus
		ShellExecute(NULL, "open", pcUrl, NULL, NULL, SW_SHOW);
		return ER_ERROR;
	}

	// Wert auslesen
	if(RegQueryValueEx(hKey, NULL, 0, 0, (unsigned char*)pcBrowser, &dwSize) != ERROR_SUCCESS)
	{
		// Fehler! Wir fhren die URL einfach so aus
		RegCloseKey(hKey);
		ShellExecute(NULL, "open", pcUrl, NULL, NULL, SW_SHOW);
		return ER_ERROR;
	}

	// Wir schlieen den Key wieder
	RegCloseKey(hKey);

	// Wir mssen eventuelle Anfhrungszeichen wegschneiden
	for(int iChar = 0; iChar < (int)strlen(pcBrowser); iChar++)
	{
		// Ist das Zeichen ein Anfhrungszeichen?
		if(pcBrowser[iChar] == '"')
		{
			// Beim ersten Zeichen ist das nicht schlimm
			if(iChar == 0)	pcBrowser = &pcBrowser[1];
			else			pcBrowser[iChar] = '\0';
		}
	}

	// Jetzt starten wir den Browser
	if((int)ShellExecute(NULL, "open", pcBrowser, pcUrl, NULL, SW_SHOW) <= 32)
	{
		// Fehler!
		ShellExecute(NULL, "open", pcUrl, NULL, NULL, SW_SHOW);
	}

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Die Threadfunktion
DWORD WINAPI CommandLineThread(void* pCommand)
{
	// Ist der Befehl valid?
	if(pCommand == NULL) return 0;
	if(strlen((char*)pCommand) <= 0) return 0;

	// Wir fhren den Befehl aus
	system((char*)pCommand);

	// Alles OK!
	return 0;
}

// ================================================================================================================================
// Fhrt einen Kommandozeilenbefehl aus
EResult CallCommandLine(char* pcCommand)
{
	DWORD	dwThreadID;		// Die ID des Threads

	// Wir starten den Thread
	return CreateThread(NULL, 0, CommandLineThread, pcCommand, 0, &dwThreadID) == NULL ? ER_ERROR : ER_OK;
}

// ================================================================================================================================
// Kodiert einen String nach dem Base64-Verfahren
char* Base64(char* pcSource)
{
	int		iLength			= (int)strlen(pcSource);
	int		iRequiredLength	= ((int)strlen(pcSource) + 2) / 3 * 4;
	char*	pcResult		= (char*)malloc((iRequiredLength + 2 * (iRequiredLength / 76) + 1)  * sizeof(char));
	DWORD	dwData			= 0;
	int		iEncodePos		= 0;
	int		iLineLength		= 0;

	if(!pcResult) return NULL;

	// Wir gehen den String durch
	for(unsigned int uiCursor = 0; uiCursor < (unsigned int)(iLength/3); uiCursor++)
	{
		// Kodieren
		dwData = (pcSource[3 * uiCursor] << 16) | (pcSource[3 * uiCursor + 1] << 8) | pcSource[3 * uiCursor +2];
		pcResult[iEncodePos++] = acEncodeChars[(dwData >> 18) & 0x3F];
		pcResult[iEncodePos++] = acEncodeChars[(dwData >> 12) & 0x3F];
		pcResult[iEncodePos++] = acEncodeChars[(dwData >> 6) & 0x3F];
		pcResult[iEncodePos++] = acEncodeChars[dwData & 0x3F];
		iLineLength += 4;

		if(iLineLength >= 76)
		{
			pcResult[iEncodePos++] = '\r';
			pcResult[iEncodePos++] = '\n';
			iLineLength = 0;
		}
	}

	// Mssen noch '=' hinzu?
	switch(iLength % 3)
	{
		case 0:
			// Es geht genau auf
			break;

		case 1:
			// Wir brauchen zwei '=', nicht vergessen: Das Ende des Strings!
			dwData = pcSource[uiCursor * 3];
			pcResult[iEncodePos++] = acEncodeChars[(dwData >> 2) & 0x3F];
			pcResult[iEncodePos++] = acEncodeChars[(dwData << 4) & 0x3F];
			pcResult[iEncodePos++] = '=';
			pcResult[iEncodePos++] = '=';
			break;

		case 2:
			// Wir brauchen ein '=', nicht vergessen: Das Ende des Strings!
			dwData = (pcSource[uiCursor * 3] << 8) | pcSource[uiCursor * 3 + 1];
			pcResult[iEncodePos++] = acEncodeChars[(dwData >> 10) & 0x3F];
			pcResult[iEncodePos++] = acEncodeChars[(dwData >> 4) & 0x3F];
			pcResult[iEncodePos++] = acEncodeChars[(dwData << 2) & 0x3F];
			pcResult[iEncodePos++] = '=';
			break;
	}

	// Alles OK!
	return pcResult;
}