// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Network.cpp                                                                                                ==
// ==                 ===========                                                                                                ==
// ==          Zweck: Schnittstelle zu WinSock                                                                                   ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Initialisiert
EResult CNetwork::Init()
{
	WSADATA WSAData;

	// Damit die Instanz mehrmals genutzt werden kann
	Exit();

	// WinSock2 initialisieren
	if(WSAStartup(MAKEWORD(2, 0), &WSAData) != 0)
	{
		// Fehler!
		char acTemp[64];
		sprintf(acTemp, GetString(IDS_WINSOCKINITERR), WSAGetLastError());
		MessageBox(NULL, acTemp, GetString(IDS_ERROR), MB_OK | MB_ICONERROR);
	}

	// Alles OK!
	m_bInitialized = TRUE;
	return ER_OK;
}

// ================================================================================================================================
// Startet eine Verbindung
EResult CNetwork::Start(char* pcUrl)
{
	unsigned long	ulIP;
	SOCKADDR_IN		SocketAddress;
	char			acTemp[512];

	// Wir erstellen den Socket
	m_Socket = socket(AF_INET, SOCK_STREAM, 0);
	if(m_Socket == INVALID_SOCKET)
	{
		// Fehler!
		sprintf(acTemp, GetString(IDS_SOCKERR), WSAGetLastError());
		ER_ERROR(acTemp);
		return ER_ERROR;
	}

	// Ist pcUrl eine IP oder ein Hostname?
	ZeroMemory(&SocketAddress, sizeof(SOCKADDR_IN));
	ulIP = inet_addr(pcUrl);
	if(ulIP == INADDR_NONE)
	{
		// Es ist ein Hostname. Eventuelle Zeichen wegschneiden
		char acUrl[256];

		// Das "http://" Am Anfang
		strcpy(acTemp, pcUrl);
		acTemp[7] = '\0';
		if(strcmp(acTemp, "http://") == 0)
			strcpy(acUrl, pcUrl + strlen("http://"));
		else
			strcpy(acUrl, pcUrl);

		// Eventuell noch ein "www."
		strcpy(acTemp, acUrl),
		acTemp[4] = '\0';
		if(strcmp(acTemp, "www.") == 0)
			strcpy(acUrl, &acUrl[4]);

		// Und ab dem ersten Slash (wenn vorhanden)
		if(strchr(acUrl, '/'))
			acUrl[strlen(acUrl) - strlen(strchr(acUrl, '/'))] = '\0';

		// Wir ermitteln die IP
		hostent* pHostent = gethostbyname(acUrl);
		if(!pHostent) ER_ERROR(GetString(IDS_ERRORHOSTNAME));
		memcpy(&SocketAddress.sin_addr, pHostent->h_addr_list[0], sizeof(sockaddr));
	}
	else
	{
		// Es ist die IP
		SocketAddress.sin_addr.s_addr	= ulIP;
	}

	// Wir konnektieren
	SocketAddress.sin_family		= AF_INET;
	SocketAddress.sin_port			= htons(80);
	if(connect(m_Socket, (SOCKADDR*)&SocketAddress, sizeof(SOCKADDR_IN)) == SOCKET_ERROR)
	{
		// Fehler
		sprintf(acTemp, GetString(IDS_CONNECTERR), pcUrl, WSAGetLastError());
		ER_ERROR(acTemp);
		return ER_ERROR;
	}

	// Wir starten den Asynchronen Modus
	if(WSAAsyncSelect(m_Socket, TN_GUI->GetMainWindow(), WM_WINSOCK, FD_READ) == SOCKET_ERROR)
	{
		// Fehler!
		sprintf(acTemp, GetString(IDS_ASYNCERR), WSAGetLastError());
		ER_ERROR(acTemp);
		return ER_ERROR;
	}

	// Wir sind konnektiert
	m_bConnected = TRUE;

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Schliet eine Verbindung
EResult CNetwork::End()
{
	// Wir schlieen den Socket
	shutdown(m_Socket, 0x02);
	closesocket(m_Socket);

	// Wir sind nicht mehr konnektiert
	m_bConnected = FALSE;

	// Alles OK!
	return ER_OK;
}

// ================================================================================================================================
// Deinitialisiert
EResult CNetwork::Exit()
{
	// Mssen wir berhaupt etwas machen?
	if(m_bInitialized)
	{
		// Ja
		// Fr alle Flle
		End();

		// WinSock beenden
		WSACleanup();

		// Die Klasse ist jetzt heruntergefahren
		m_bInitialized = FALSE;
	}

	// Alles OK!
	return ER_OK;
}
