// ================================================================================================================================
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ==      Dateiname: Popup.cpp                                                                                                  ==
// ==                 =========                                                                                                  ==
// ==          Zweck: Die Funktionen dieser Datei verwalten das Popup                                                            ==
// ==          Autor: Seku                                                                                                       ==
// ==                                                                                                                            ==
// ==                                                                                                                            ==
// ================================================================================================================================

#include "../include/Traied Nagios.h"

// ================================================================================================================================
// Globale Variablen
HANDLE	g_hThread;			// Das Handle des Threads
HWND	g_hPopupWindow;		// Das Fenster
BYTE	g_Color;			// Die Hintergrundfarbe je nach Typ des Popups (OK, Unbekannt, Warnung, Fehler)
char*	g_pcMessage = NULL;	// Die Nachricht

// ================================================================================================================================
// Die Fensterfunktion des Popupfensters
LRESULT CALLBACK PopupProc(HWND hWindow, unsigned int uiMsg, WPARAM WParam, LPARAM LParam)
{
	PAINTSTRUCT Paint;
	HBRUSH		hBackgroundBrush, hOldBrush;
	HPEN		hBorderPen, hOldPen;
	HFONT		hFont, hOldFont;
	RECT		Rect;

	// Was ist los?
	switch(uiMsg)
	{
		case WM_CREATE:
			// Das Fenster wurde erstellt. Wir starten den Timer
			SetTimer(hWindow, 1, 15000, NULL);
			break;

		case WM_TIMER:
			// Ein Timer geht weiter
			// Das Fenster wird beendet
			PostQuitMessage(1);
			break;

		case WM_PAINT:
			// Fenster wird gemalt
			BeginPaint(hWindow, &Paint);

			// Werkzeuge erstellen
			if(g_Color == 0)	hBackgroundBrush	= CreateSolidBrush(RGB(  0, 200,    0));
			if(g_Color == 1) 	hBackgroundBrush	= CreateSolidBrush(RGB(120, 120,  120));
			if(g_Color == 2)	hBackgroundBrush	= CreateSolidBrush(RGB(255, 250,    0));
			if(g_Color == 3)	hBackgroundBrush	= CreateSolidBrush(RGB(255,  20,    0));
			hBorderPen			= CreatePen(PS_SOLID, 10, RGB(60, 0, 0));

			// Hintergrund lschen
			hOldBrush = (HBRUSH)SelectObject(Paint.hdc, hBackgroundBrush);
			FillRect(Paint.hdc, &Paint.rcPaint, hBackgroundBrush);

			// Rahmen malen
			hOldPen = (HPEN)SelectObject(Paint.hdc, hBorderPen);
			Rectangle(Paint.hdc, 0, 0, 300, 200);

			// Wir geben den Text aus.. Schrift erstellen
			hFont = CreateFont(20, 10, 0, 0, FW_BOLD, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_TT_PRECIS,
							   CLIP_CHARACTER_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH, "Arial");
			hOldFont = (HFONT)SelectObject(Paint.hdc, hFont);

			// Farben setzen
			if(g_Color == 2)	SetTextColor(Paint.hdc,	RGB(  0,   0,   0));
			else				SetTextColor(Paint.hdc,	RGB(255, 255, 255));

			if(g_Color == 0)	SetBkColor(Paint.hdc,	RGB(  0, 200,   0));
			if(g_Color == 1) 	SetBkColor(Paint.hdc,	RGB(120, 120, 120));
			if(g_Color == 2)	SetBkColor(Paint.hdc,	RGB(255, 250,   0));
			if(g_Color == 3)	SetBkColor(Paint.hdc,	RGB(255,  20,   0));

			// Rechteck vorbereiten
			Rect.left	= Paint.rcPaint.left	+ 10;
			Rect.right	= Paint.rcPaint.right	- 10;
			Rect.top	= Paint.rcPaint.top		+ 10;
			Rect.bottom	= Paint.rcPaint.bottom	- 10;

			// Malen
			DrawText(Paint.hdc, g_pcMessage, strlen(g_pcMessage), &Rect, DT_CENTER | DT_WORDBREAK);

			// Werkzeuge lschen
			SelectObject(Paint.hdc, hOldFont);		DeleteObject(hFont);
			SelectObject(Paint.hdc, hOldBrush);		DeleteObject(hBackgroundBrush);
			SelectObject(Paint.hdc, hOldPen);		DeleteObject(hBorderPen);

			// Ende
			EndPaint(hWindow, &Paint);
			break;

		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
			// Fenster schlieen
			PostQuitMessage(1);
			break;

		case WM_CLOSE:
			// Fenster schlieen
			PostQuitMessage(1);
			break;

		default:
			// Nachricht an Windows weitergeben
			return DefWindowProc(hWindow, uiMsg, WParam, LParam);
			break;
	}

	// Alles OK!
	return TRUE;
}

// ================================================================================================================================
// Die Threadfunktion
DWORD WINAPI PopupThread(void* pParameter)
{
	WNDCLASSEX	WindowClass;
	MSG			Message;

	// Die Fensterklasse
	ZeroMemory(&WindowClass, sizeof(WNDCLASSEX));
	WindowClass.cbSize			= sizeof(WNDCLASSEX);
	WindowClass.style			= CS_CLASSDC;
	WindowClass.lpfnWndProc		= PopupProc;
	WindowClass.cbClsExtra		= 0;
	WindowClass.cbWndExtra		= 0;
	WindowClass.hInstance		= TN_MAIN.GetProgramInstance();
	WindowClass.hIcon			= LoadIcon(TN_MAIN.GetProgramInstance(), MAKEINTRESOURCE(ID_ICON_NORMAL));
	WindowClass.hIconSm			= WindowClass.hIcon;
	WindowClass.hCursor			= LoadIcon(TN_MAIN.GetProgramInstance(), IDC_ARROW);
	WindowClass.hbrBackground	= (HBRUSH)GetSysColorBrush(COLOR_3DFACE);
	WindowClass.lpszMenuName	= NULL;
	WindowClass.lpszClassName	= TN_POPUPCLASS;
	RegisterClassEx(&WindowClass);	// Wir prfen nicht auf Erfolg, da dies ein zweites Popup hindern wrde

	// Wir erstellen das Fenster
	g_hPopupWindow = CreateWindowEx(WS_EX_TOPMOST,
									TN_POPUPCLASS,
									g_pcMessage,
									WS_VISIBLE | WS_POPUP,
									GetSystemMetrics(SM_CXSCREEN)/2 - 300/2,
									GetSystemMetrics(SM_CYSCREEN)/2 - 200/2,
									300, 200,
									NULL,
									NULL,
									TN_MAIN.GetProgramInstance(),
									NULL);
	if(!g_hPopupWindow) return 0;

	// Wir starten die Fensterschleife
	ZeroMemory(&Message, sizeof(MSG));
	while(GetMessage(&Message, 0, 0, 0))
	{
		// Nachricht weiterleiten
		TranslateMessage(&Message);
		DispatchMessage(&Message);
		if(Message.message == WM_QUIT)
			break;
	}

	// Alles OK!
	return 0;
}

// ================================================================================================================================
// Erstellt ein Popup
EResult DoPopup(char* pcText, BYTE Color)
{
	DWORD	dwThreadID;	// Die ID des Threads

	// altes Fenster und alten Thread beenden
	DestroyWindow(g_hPopupWindow);
	TerminateThread(g_hThread, 0);

	// Wir globalisieren die gewnschte Farbe
	g_Color = Color;

	// Wir globalisieren den Text
	if(g_pcMessage != NULL) free(g_pcMessage);
	g_pcMessage = (char*)malloc((strlen(pcText)+strlen("Traied Nagios:\n\n")+1) * sizeof(char));
	sprintf(g_pcMessage, "Traied Nagios:\n\n%s", pcText);

	// Wir starten den Thread
	g_hThread = CreateThread(NULL, 0, PopupThread, pcText, 0, &dwThreadID);
	if(g_hThread == NULL) return ER_ERROR;

	// Alles OK!
	return ER_OK;
}