# Options for Redhat 6.x version:
# rpm -ba|--rebuild --define "rh6 1"
#
# Options for Redhat 5.x version:
# rpm -ba|--rebuild --define "rh5 1"
#

%define redhat6 0
%{?rh6:%define redhat6 1}

%define redhat5 0
%{?rh5:%define redhat5 1}

%define rel 1

Summary: Service repair tools for Nagios(tm)
Name: repairer
Version: 0.4.5
%if "%{redhat6}" == "1"
Release: %{rel}.6.x
Requires: ucd-snmp
%else
%if "%{redhat5}" == "1"
Release: %{rel}.5.x
Requires: ucd-snmp
%else
Release: %{rel}
Requires: net-snmp
%endif
%endif

Copyright: GPL
Group: System/Utilities
Source: %{name}-%{version}.tar.gz
Requires: /bin/bash
BuildArchitectures: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root


%description
empty yet

%package master
Summary: Service repair tools master for Nagios(tm)
Group: System/Utilities
Requires: net-snmp, /usr/bin/perl, nagios, repairer
BuildArchitectures: noarch

%description master
empty yet

%prep
%setup -q

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/etc
mkdir -p ${RPM_BUILD_ROOT}/usr/bin
mkdir -p ${RPM_BUILD_ROOT}/usr/lib/nagios/eventhandlers
mkdir -p ${RPM_BUILD_ROOT}/usr/nagios
install -m 755 repairer ${RPM_BUILD_ROOT}/usr/bin
install -m 755 subsys_event_handler ${RPM_BUILD_ROOT}/usr/lib/nagios/eventhandlers
cp -a repairer.etc ${RPM_BUILD_ROOT}/etc/repairer
cp -a nagios.etc ${RPM_BUILD_ROOT}/etc/nagios

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%{_bindir}/*
/etc/repairer/
%doc snmpd-addon README TODO

%files master
%defattr(-,root,root)
/usr/lib/nagios/eventhandlers/*
%config(noreplace) /etc/nagios/subsys*cfg

