{   Copyright (C) 2005  Hugo Monteiro (hvm_pt@users.sourceforge.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, OleCtrls, SHDocVw, ExtCtrls, IniFiles, Menus, ToolWin,
  ImgList;

type
  TMainForm = class(TForm)
    WebBrowser: TWebBrowser;
    StatusBar: TStatusBar;
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    ExitSubMenu: TMenuItem;
    NagiosMenu: TMenuItem;
    HelpMenu: TMenuItem;
    AboutSubMenu: TMenuItem;
    MonitoringMenu: TMenuItem;
    ReportingMenu: TMenuItem;
    TacticalOverviewSubMenu: TMenuItem;
    ServiceDetailSubMenu: TMenuItem;
    HostDetailSubMenu: TMenuItem;
    HostgroupOverviewSubMenu: TMenuItem;
    HostgroupSummarySubMenu: TMenuItem;
    HostgroupGridSubMenu: TMenuItem;
    ServicegroupOverviewSubMenu: TMenuItem;
    ServicegroupSummarySubMenu: TMenuItem;
    ServicegroupGridSubMenu: TMenuItem;
    StatusMapSubMenu: TMenuItem;
    N1: TMenuItem;
    ServiceProblemsSubMenu: TMenuItem;
    HostProblemsSubMenu: TMenuItem;
    NetworkOutagesSubMenu: TMenuItem;
    ProcessInfoSubMenu: TMenuItem;
    PerformanceInfoSubMenu: TMenuItem;
    SchedulingQueueSubMenu: TMenuItem;
    N2: TMenuItem;
    CommentsSubMenu: TMenuItem;
    DowntimeSubMenu: TMenuItem;
    TrendsSubMenu: TMenuItem;
    AvailabilitySubMenu: TMenuItem;
    AlertHistogramSubMenu: TMenuItem;
    AlertHistorySubMenu: TMenuItem;
    AlertSummarySubMenu: TMenuItem;
    NotificationsSubMenu: TMenuItem;
    EventLogSubMenu: TMenuItem;
    ViewConfigSubMenu: TMenuItem;
    ConfigurationSubMenu: TMenuItem;
    NagiosDocumentationSubMenu: TMenuItem;
    NagiosWebsiteSubMenu: TMenuItem;
    N3: TMenuItem;
    PrintSubMenu: TMenuItem;
    PrintDialog: TPrintDialog;
    PopupMenu: TPopupMenu;
    Refresh2SubMenu: TMenuItem;
    N4: TMenuItem;
    FullScreenSubMenu: TMenuItem;
    FullScreenSubMenu2: TMenuItem;
    N5: TMenuItem;
    SaveToDiskSubMenu: TMenuItem;
    SaveDialog: TSaveDialog;
    ShowMainMenuSubMenu: TMenuItem;
    ShowToolbarSubMenu: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    ToolBar: TToolBar;
    ExitToolButton: TToolButton;
    ToolButton2: TToolButton;
    TacticalOverviewToolButton: TToolButton;
    ServiceDetailToolButton: TToolButton;
    HostDetailToolButton: TToolButton;
    HostgroupSummaryToolButton: TToolButton;
    ServiceGroupSummaryToolButton: TToolButton;
    ToolButton8: TToolButton;
    ServiceProblemsToolButton: TToolButton;
    HostProblemsToolButton: TToolButton;
    NetworkOutagesToolButton: TToolButton;
    FullScreenToolButton: TToolButton;
    ToolButton13: TToolButton;
    ToolbarImageList: TImageList;
    RefreshToolButton: TToolButton;
    ToolButton3: TToolButton;
    ToolButton1: TToolButton;
    ShowStatusbarSubMenu: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    ExitSubMenu2: TMenuItem;
    RefreshSubMenu: TMenuItem;
    N10: TMenuItem;
    ToolButton4: TToolButton;
    procedure FormActivate(Sender: TObject);
    procedure ExitSubMenuClick(Sender: TObject);
    procedure TacticalOverviewSubMenuClick(Sender: TObject);
    procedure ServiceDetailSubMenuClick(Sender: TObject);
    procedure HostDetailSubMenuClick(Sender: TObject);
    procedure HostgroupOverviewSubMenuClick(Sender: TObject);
    procedure HostgroupSummarySubMenuClick(Sender: TObject);
    procedure HostgroupGridSubMenuClick(Sender: TObject);
    procedure ServicegroupOverviewSubMenuClick(Sender: TObject);
    procedure ServicegroupSummarySubMenuClick(Sender: TObject);
    procedure ServicegroupGridSubMenuClick(Sender: TObject);
    procedure StatusMapSubMenuClick(Sender: TObject);
    procedure ServiceProblemsSubMenuClick(Sender: TObject);
    procedure HostProblemsSubMenuClick(Sender: TObject);
    procedure NetworkOutagesSubMenuClick(Sender: TObject);
    procedure TrendsSubMenuClick(Sender: TObject);
    procedure CommentsSubMenuClick(Sender: TObject);
    procedure DowntimeSubMenuClick(Sender: TObject);
    procedure ProcessInfoSubMenuClick(Sender: TObject);
    procedure PerformanceInfoSubMenuClick(Sender: TObject);
    procedure SchedulingQueueSubMenuClick(Sender: TObject);
    procedure AvailabilitySubMenuClick(Sender: TObject);
    procedure AlertHistogramSubMenuClick(Sender: TObject);
    procedure AlertHistorySubMenuClick(Sender: TObject);
    procedure AlertSummarySubMenuClick(Sender: TObject);
    procedure NotificationsSubMenuClick(Sender: TObject);
    procedure EventLogSubMenuClick(Sender: TObject);
    procedure ViewConfigSubMenuClick(Sender: TObject);
    procedure PrintSubMenuClick(Sender: TObject);
    procedure RefreshSubMenuClick(Sender: TObject);
    procedure StopRefreshSubMenuClick(Sender: TObject);
    procedure FullScreenSubMenuClick(Sender: TObject);
    procedure ConfigurationSubMenuClick(Sender: TObject);
    procedure WebBrowserDownloadBegin(Sender: TObject);
    procedure WebBrowserDocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure WebBrowserBeforeNavigate2(Sender: TObject;
      const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
      Headers: OleVariant; var Cancel: WordBool);
    procedure FormCreate(Sender: TObject);
    procedure GotoStartupPage(Sender: TObject);
    procedure GetStartupPage;
    procedure AboutSubMenuClick(Sender: TObject);
    procedure SaveToDiskSubMenuClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ShowToolbarSubMenuClick(Sender: TObject);
    procedure ShowMainMenuSubMenuClick(Sender: TObject);
    procedure ShowStatusbarSubMenuClick(Sender: TObject);
    procedure NetworkOutagesToolButtonClick(Sender: TObject);
    procedure HostProblemsToolButtonClick(Sender: TObject);
    procedure ServiceProblemsToolButtonClick(Sender: TObject);
    procedure ServiceGroupSummaryToolButtonClick(Sender: TObject);
    procedure HostgroupSummaryToolButtonClick(Sender: TObject);
    procedure HostDetailToolButtonClick(Sender: TObject);
    procedure ServiceDetailToolButtonClick(Sender: TObject);
    procedure TacticalOverviewToolButtonClick(Sender: TObject);
    procedure NagiosDocumentationSubMenuClick(Sender: TObject);
    procedure NagiosWebsiteSubMenuClick(Sender: TObject);
  private
    { Private declarations }
    CurrentURL: String;

    procedure SaveHTMLSourceToFile(const FileName: string; WB: TWebBrowser);
    procedure CheckRightMenuSubItem(Sender: TObject);
  public
    { Public declarations }
    ProxyEnabled: Boolean;
    NagiosWebURL, NagiosCGIURL, NagiosUsername, NagiosPassword,
    ProxyHostname, ProxyPort, ProxyUsername, ProxyPassword,
    StartupPage: String;

    OldTop, OldLeft, OldWidth, OldHeight: Integer;
    NagiosDocStayOnTop, OldToolbarVisible, OldMainMenuVisible, OldStatusbarVisible: Boolean;

    MyIniFile : TCustomIniFile;
    Procedure ReadIniFile(Sender: TObject);
    Procedure WriteIniFile(Sender: TObject);
    procedure ExecuteExternalURL(URL: String);

    procedure ClearCheckedMenuSubItems;
    procedure EnableMenuAndToolbarButtons(Sender: TObject);
    procedure DisableMenuAndToolbarButtons(Sender: TObject);
    procedure UnSelectMenuAndToolbarButtons(Sender: TObject);
  end;


function MouseProc(nCode: Integer; wParam, lParam: Longint): Longint; stdcall;

var
  MainForm: TMainForm;
  HookID: THandle;

implementation

uses Unit2, Unit3, ActiveX, Unit5, ShellApi;

{$R *.dfm}

function MouseProc(nCode: Integer; wParam, lParam: Longint): Longint; stdcall;
var
  szClassName: array[0..255] of Char;
  MausPos: TPoint;
  X, Y: Integer;
const
  ie_name = 'Internet Explorer_Server';
begin
  GetCursorPos(MausPos);
  x := MausPos.x;
  y := MausPos.y;

  case nCode < 0 of
    True:
      Result := CallNextHookEx(HookID, nCode, wParam, lParam)
      else
        case wParam of
          WM_RBUTTONDOWN,
          WM_RBUTTONUP:
            begin
              GetClassName(PMOUSEHOOKSTRUCT(lParam)^.HWND, szClassName, SizeOf(szClassName));
              if lstrcmp(@szClassName[0], @ie_name[1]) = 0 then
              begin
                Result := HC_SKIP;
                MainForm.PopupMenu.popup(X, Y);
              end
              else
                Result := CallNextHookEx(HookID, nCode, wParam, lParam);
            end
            else
              Result := CallNextHookEx(HookID, nCode, wParam, lParam);
        end;
  end;
end;


procedure TMainForm.FormActivate(Sender: TObject);
begin
     {use our own popup menu in a TWebBrowser component}
     HookID := SetWindowsHookEx(WH_MOUSE, MouseProc, 0, GetCurrentThreadId());

//     WebBrowser.Navigate(NagiosCGIURL+'tac.cgi');
end;

procedure TMainForm.ExitSubMenuClick(Sender: TObject);
begin
     MainForm.Close;
end;

procedure TMainForm.ClearCheckedMenuSubItems;
var I: Integer;
begin
     For I:=0 to MonitoringMenu.Count-1 do
         MonitoringMenu.Items[I].Checked:=False;
     For I:=0 to ReportingMenu.Count-1 do
         ReportingMenu.Items[I].Checked:=False;
     For I:=0 to NagiosMenu.Count-1 do
         NagiosMenu.Items[I].Checked:=False;
end;

procedure TMainForm.CheckRightMenuSubItem(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     If Sender is TMenuItem Then
        (Sender as TMenuItem).Checked:=True;
end;

procedure TMainForm.TacticalOverviewSubMenuClick(Sender: TObject);
begin
     TacticalOverviewToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     TacticalOverviewSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'tac.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServiceDetailSubMenuClick(Sender: TObject);
begin
     ServiceDetailToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServiceDetailSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostDetailSubMenuClick(Sender: TObject);
begin
     HostDetailToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostDetailSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostgroupOverviewSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     HostgroupOverviewSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=overview';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostgroupSummarySubMenuClick(Sender: TObject);
begin
     HostgroupSummaryToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostgroupSummarySubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=summary';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostgroupGridSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     HostgroupGridSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=grid';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServicegroupOverviewSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     ServicegroupOverviewSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=overview';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServicegroupSummarySubMenuClick(Sender: TObject);
begin
     HostgroupSummaryToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServicegroupSummarySubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=summary';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServicegroupGridSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     ServicegroupGridSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=grid';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.StatusMapSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     StatusMapSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'statusmap.cgi?host=all';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServiceProblemsSubMenuClick(Sender: TObject);
begin
     ServiceProblemsToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServiceProblemsSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all&servicestatustypes=28';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostProblemsSubMenuClick(Sender: TObject);
begin
     HostProblemsToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostProblemsSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.NetworkOutagesSubMenuClick(Sender: TObject);
begin
     NetworkOutagesToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     NetworkOutagesSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'outages.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.TrendsSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     TrendsSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'trends.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.CommentsSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     CommentsSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'extinfo.cgi?&type=3';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.DowntimeSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     DowntimeSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'extinfo.cgi?&type=6';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ProcessInfoSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     ProcessInfoSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'extinfo.cgi?&type=0';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.PerformanceInfoSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     PerformanceInfoSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'extinfo.cgi?&type=4';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.SchedulingQueueSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     SchedulingQueueSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'extinfo.cgi?&type=7';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.AvailabilitySubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     AvailabilitySubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'avail.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.AlertHistogramSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     AlertHistogramSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'histogram.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.AlertHistorySubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     AlertHistorySubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'history.cgi?host=all';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.AlertSummarySubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     AlertSummarySubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'summary.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.NotificationsSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     NotificationsSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'notifications.cgi?contact=all';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.EventLogSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     EventLogSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'showlog.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ViewConfigSubMenuClick(Sender: TObject);
begin
     ClearCheckedMenuSubItems;
     ViewConfigSubMenu.Checked:=True;

     MainForm.CurrentURL:=NagiosCGIURL+'config.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.PrintSubMenuClick(Sender: TObject);
begin
     PrintDialog.Execute;
end;

procedure TMainForm.RefreshSubMenuClick(Sender: TObject);
begin
     If (RefreshToolButton.ImageIndex = 11) Then { It means Browser is already trying to connect }
     Begin
          WebBrowser.Stop;
          EnableMenuAndToolbarButtons(Sender);
     end
     else WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.StopRefreshSubMenuClick(Sender: TObject);
begin
     WebBrowser.Stop;
     EnableMenuAndToolbarButtons(Sender);
end;

procedure TMainForm.FullScreenSubMenuClick(Sender: TObject);
begin
     If (FullScreenSubMenu.Checked) Then
     Begin
          { Normal Mode }
          FullScreenSubMenu.Checked:=False;
          FullScreenSubMenu2.Checked:=False;

          MainForm.FormStyle:=fsNormal;
          MainForm.BorderStyle:=bsSizeable;

          MainForm.Top:=OldTop;
          MainForm.Left:=OldLeft;
          MainForm.Width:=OldWidth;
          MainForm.Height:=OldHeight;

          ShowMainMenuSubMenu.Enabled:=True;
          ShowToolbarSubMenu.Enabled:=True;
          ShowStatusbarSubMenu.Enabled:=True;

          Statusbar.Visible:=OldStatusbarVisible;
          ShowStatusbarSubMenu.Checked:=OldStatusbarVisible;
          Toolbar.Visible:=OldToolbarVisible;
          ShowToolbarSubMenu.Checked:=OldToolbarVisible;
          If OldMainMenuVisible Then
             ShowMainMenuSubMenuClick(Sender);
     end
     else
     Begin
          { Full Screen Mode }
          FullScreenSubMenu.Checked:=True;
          FullScreenSubMenu2.Checked:=True;

          ShowMainMenuSubMenu.Enabled:=False;
          ShowToolbarSubMenu.Enabled:=False;
          ShowStatusbarSubMenu.Enabled:=False;

          OldStatusbarVisible:=Statusbar.Visible;
          OldToolbarVisible:=Toolbar.Visible;
          OldMainMenuVisible:=MainMenu.Items[0].Visible;

          OldTop:=MainForm.Top;
          OldLeft:=MainForm.Left;
          OldWidth:=MainForm.Width;
          OldHeight:=MainForm.Height;

          MainForm.BorderStyle:=bsNone;
          MainForm.FormStyle:=fsStayOnTop;
          MainForm.Top:=0;
          MainForm.Left:=0;
          MainForm.Width:=Screen.Width;
          MainForm.Height:=Screen.Height;
          If MainMenu.Items.Items[0].Visible Then
             ShowMainMenuSubMenuClick(Sender);
          If Toolbar.Visible Then
             ShowToolbarSubMenuClick(Sender);
          If Statusbar.Visible Then
             ShowStatusbarSubMenuClick(Sender);
     end;
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ConfigurationSubMenuClick(Sender: TObject);
begin
     If (ConfigurationForm.ShowModal = mrOk) Then
     Begin
          MainForm.NagiosWebURL:=ConfigurationForm.NagiosWebURLEdit.Text;
          MainForm.NagiosCGIURL:=ConfigurationForm.NagiosCGIURLEdit.Text;
          MainForm.NagiosUsername:=ConfigurationForm.NagiosUsernameEdit.Text;
          MainForm.NagiosPassword:=ConfigurationForm.NagiosPasswordEdit.Text;
          MainForm.ProxyEnabled:=ConfigurationForm.ProxyEnabledCheckBox.Checked;
          MainForm.ProxyHostname:=ConfigurationForm.ProxyHostnameEdit.Text;
          MainForm.ProxyPort:=ConfigurationForm.ProxyPortEdit.Text;
          MainForm.ProxyUsername:=ConfigurationForm.ProxyUsernameEdit.Text;
          MainForm.ProxyPassword:=ConfigurationForm.ProxyPasswordEdit.Text;
          MainForm.StartupPage:=ConfigurationForm.StartupPageComboBox.Items.Strings[ConfigurationForm.StartupPageComboBox.ItemIndex];
          MainForm.WriteIniFile(Sender);
          If (NagiosWebURL = '') or (NagiosCGIURL = '') Then
          Begin
               DisableMenuAndToolbarButtons(Sender);
               Exit;
          end
          else
          Begin
               EnableMenuAndToolbarButtons(Sender);
               GotoStartupPage(Sender);
          end;


     end;
end;

procedure TMainForm.WebBrowserDownloadBegin(Sender: TObject);
begin
     StatusBar.Panels.Items[1].Text:='Connecting...';
end;

procedure TMainForm.WebBrowserDocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
     StatusBar.Panels.Items[1].Text:='Connected!';
     EnableMenuAndToolbarButtons(Sender);
end;

procedure TMainForm.WebBrowserBeforeNavigate2(Sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
begin
     If (URL = '') Then
     Begin
          Cancel:=False;
          Exit;
     end;
     If (MainForm.NagiosWebURL = '') or (MainForm.NagiosCGIURL = '') Then
     Begin
          DisableMenuAndToolbarButtons(Sender);
          Cancel:=False;
          Exit;
     end;

     // Intercept ALL outside URLs and call the default browser
     If (Copy(URL, 0, Length(MainForm.NagiosWebURL)) = MainForm.NagiosWebURL) Then
     Begin
          MainForm.ExecuteExternalURL(URL);
          Cancel:=True;
          Exit;
     end;

     StatusBar.Panels.Items[1].Text:='Loading...';
     DisableMenuAndToolbarButtons(Sender);
     { Check if Navigated URL is one of our Menus }
     If (URL = NagiosCGIURL+'tac.cgi') Then
        TacticalOverviewToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?host=all') Then
        ServiceDetailToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail') Then
        HostDetailToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?hostgroup=all&style=summary') Then
        HostgroupSummaryToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?servicegroup=all&style=summary') Then
        ServiceGroupSummaryToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?host=all&servicestatustypes=28') Then
        ServiceProblemsToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12') Then
        HostProblemsToolButton.Down:=True
     else
     If (URL = NagiosCGIURL+'outages.cgi') Then
        NetworkOutagesToolButton.Down:=True
     else
         UnSelectMenuAndToolbarButtons(Sender);
end;

procedure TMainForm.FormCreate(Sender: TObject);
var I: Integer;
begin
     {use our own popup menu in a TWebBrowser component}
//     HookID := SetWindowsHookEx(WH_MOUSE, MouseProc, 0, GetCurrentThreadId());

     NagiosWebURL:='';
     NagiosCGIURL:='';
     NagiosUsername:='';
     NagiosPassword:='';
     ProxyHostname:='';
     ProxyPort:='';
     ProxyUsername:='';
     ProxyPassword:='';
     CurrentURL:='';
     StatusBar.Panels.Items[0].Width:=MainForm.ClientWidth-155;
     StatusBar.Panels.Items[0].Text:='';
     StatusBar.Panels.Items[1].Text:='';

     MyIniFile:=TIniFile.Create(ExtractFilePath(Application.ExeName)+'flashnagios.ini');
     If Not FileExists(ExtractFilePath(Application.ExeName)+'flashnagios.ini') Then
     Begin
          DisableMenuAndToolbarButtons(Sender);
          Exit;
     end;
     MainForm.ReadIniFile(Sender);
     If (NagiosWebURL = '') or (NagiosCGIURL = '') Then
     Begin
          DisableMenuAndToolbarButtons(Sender);
          Exit;
     end;

     { check for command line parameters }
     For I:=1 to ParamCount do
     Begin
          If (LowerCase(ParamStr(i)) = '-fullscreen') or (LowerCase(ParamStr(i)) = '/fullscreen') Then
          FullScreenSubMenuClick(Sender);
     end;

     GotoStartupPage(Sender);
end;


procedure TMainForm.GotoStartupPage(Sender: TObject);
begin
     If StartupPage = 'Tactical Overview' Then TacticalOverviewSubMenuClick(Sender)
     else
     If StartupPage = 'Service Detail' Then ServiceDetailSubMenuClick(Sender)
     else
     If StartupPage = 'Host Detail' Then HostDetailSubMenuClick(Sender)
     else
     If StartupPage = 'Hostgroup Overview' Then HostgroupOverviewSubMenuClick(Sender)
     else
     If StartupPage = 'Hostgroup Summary' Then HostgroupSummarySubMenuClick(Sender)
     else
     If StartupPage = 'Hostgroup Summary' Then  HostgroupSummaryToolButtonClick(Sender)
     else
     If StartupPage = 'Hostgroup Grid' Then HostgroupGridSubMenuClick(Sender)
     else
     If StartupPage = 'Servicegroup Overview' Then ServicegroupOverviewSubMenuClick(Sender)
     else
     If StartupPage = 'Servicegroup Summary' Then ServicegroupSummarySubMenuClick(Sender)
     else
     If StartupPage = 'Servicegroup Grid' Then ServicegroupGridSubMenuClick(Sender)
     else
     If StartupPage = 'Status Map' Then ServiceProblemsSubMenuClick(Sender)
     else
     If StartupPage = 'Service Problems' Then ServiceProblemsToolButtonClick(Sender)
     else
     If StartupPage = 'Host Problems' Then  HostProblemsSubMenuClick(Sender)
     else
     If StartupPage = 'Network Outages' Then  NetworkOutagesSubMenuClick(Sender);
end;

procedure TMainForm.GetStartupPage;
begin
     If StartupPage = 'Tactical Overview' Then MainForm.CurrentURL:=NagiosCGIURL+'tac.cgi'
     else
     If StartupPage = 'Service Detail' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all'
     else
     If StartupPage = 'Host Detail' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail'
     else
     If StartupPage = 'Hostgroup Overview' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=overview'
     else
     If StartupPage = 'Hostgroup Summary' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=summary'
     else
     If StartupPage = 'Hostgroup Grid' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=grid'
     else
     If StartupPage = 'Servicegroup Overview' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=overview'
     else
     If StartupPage = 'Servicegroup Summary' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=summary'
     else
     If StartupPage = 'Servicegroup Grid' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=grid'
     else
     If StartupPage = 'Status Map' Then  MainForm.CurrentURL:=NagiosCGIURL+'statusmap.cgi?host=all'
     else
     If StartupPage = 'Service Problems' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all&servicestatustypes=28'
     else
     If StartupPage = 'Host Problems' Then MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12'
     else
     If StartupPage = 'Network Outages' Then  MainForm.CurrentURL:=NagiosCGIURL+'outages.cgi'
end;


Procedure TMainForm.ReadIniFile(Sender: TObject);

Begin
     MainForm.OldWidth:=MyIniFile.ReadInteger('General', 'Width', 0);
     MainForm.OldHeight:=MyIniFile.ReadInteger('General', 'Height', 0);
     MainForm.OldTop:=MyIniFile.ReadInteger('General', 'Top', 0);
     MainForm.OldLeft:=MyIniFile.ReadInteger('General', 'Left', 0);

     MainForm.Top:=OldTop;
     MainForm.Left:=OldLeft;
     MainForm.Width:=OldWidth;
     MainForm.Height:=OldHeight;

     If (MainForm.OldWidth <> 0) Then
        MainForm.Width:=MainForm.OldWidth;
     If (MainForm.OldHeight <> 0) Then
        MainForm.Height:=MainForm.OldHeight;
     If (MainForm.OldTop <> 0) Then
        MainForm.Top:=MainForm.OldTop;
     If (MainForm.OldLeft <> 0) Then
        MainForm.Left:=MainForm.OldLeft;

     Toolbar.Visible:=MyIniFile.ReadBool('General', 'Show Toolbar', TRUE);
     Statusbar.Visible:=MyIniFile.ReadBool('General', 'Show Statusbar', TRUE);
     NagiosDocStayOnTop:=MyIniFile.ReadBool('General', 'NagiosDoc StayOnTop', FALSE);
     StartupPage:=MyIniFile.ReadString('General', 'Startup Page', 'Tactical Overview');
     If MyIniFile.ReadBool('General', 'Show Menu', TRUE) Then
     Begin
          { Trick the value to force the Menu to be shown with the next call to the function }
          MainMenu.Items[0].Visible:=False;
          ShowMainMenuSubMenuClick(Sender);
     end;

     NagiosWebURL:=MyIniFile.ReadString('Nagios', 'WebURL', '');
     NagiosCGIURL:=MyIniFile.ReadString('Nagios', 'CGIURL', '');
     NagiosUsername:=MyIniFile.ReadString('Nagios', 'Username', '');
     NagiosPassword:=MyIniFile.ReadString('Nagios', 'Password', '');

     ProxyEnabled:=MyIniFile.ReadBool('Proxy', 'Enabled', FALSE);
     ProxyHostname:=MyIniFile.ReadString('Proxy', 'Hostname', '');
     ProxyPort:=MyIniFile.ReadString('Proxy', 'Port', '');
     ProxyUsername:=MyIniFile.ReadString('Proxy', 'Username', '');
     ProxyPassword:=MyIniFile.ReadString('Proxy', 'Password', '');

     If MyIniFile.ReadBool('General', 'Fullscreen', TRUE) Then
     Begin
          FullScreenSubMenu.Checked:=False; { Trick the value so we can get into fullscreen }
          FullScreenSubMenu2.Checked:=False;
          GetStartupPage;
          FullScreenSubMenuClick(Sender);
     end;
end;

Procedure TMainForm.WriteIniFile(Sender: TObject);
Begin
     { If it's fullscreen, we want to save the old/original status, not the current,
      because in fullscreen mode, everything is hidden }
     If FullScreenSubMenu.Checked Then
     Begin
          MyIniFile.WriteInteger('General', 'Width', MainForm.OldWidth);
          MyIniFile.WriteInteger('General', 'Height', MainForm.OldHeight);
          MyIniFile.WriteInteger('General', 'Top', MainForm.OldTop);
          MyIniFile.WriteInteger('General', 'Left', MainForm.OldLeft);

          MyIniFile.WriteBool('General', 'Fullscreen', FullScreenSubMenu.Checked);
          MyIniFile.WriteBool('General', 'Show Toolbar', OldToolbarVisible);
          MyIniFile.WriteBool('General', 'Show Statusbar', OldStatusbarVisible);
          MyIniFile.WriteBool('General', 'Show Menu', OldMainMenuVisible);
          MyIniFile.WriteBool('General', 'NagiosDoc StayOnTop', NagiosDocForm.StayOnTopCheckBox.Checked);
          MyIniFile.WriteString('General', 'Startup Page', StartupPage);
     end
     else
     Begin
          MyIniFile.WriteInteger('General', 'Width', MainForm.Width);
          MyIniFile.WriteInteger('General', 'Height', MainForm.Height);
          MyIniFile.WriteInteger('General', 'Top', MainForm.Top);
          MyIniFile.WriteInteger('General', 'Left', MainForm.Left);

          MyIniFile.WriteBool('General', 'Fullscreen', FullScreenSubMenu.Checked);
          MyIniFile.WriteBool('General', 'Show Toolbar', Toolbar.Visible);
          MyIniFile.WriteBool('General', 'Show Statusbar', Statusbar.Visible);
          MyIniFile.WriteBool('General', 'Show Menu', MainMenu.Items[0].Visible);
          MyIniFile.WriteBool('General', 'NagiosDoc StayOnTop', NagiosDocForm.StayOnTopCheckBox.Checked);
          MyIniFile.WriteString('General', 'Startup Page', StartupPage);
     end;

     MyIniFile.WriteString('Nagios', 'WebURL', NagiosWebURL);
     MyIniFile.WriteString('Nagios', 'CGIURL', NagiosCGIURL);
     MyIniFile.WriteString('Nagios', 'Username', NagiosUsername);
     MyIniFile.WriteString('Nagios', 'Password', NagiosPassword);

     MyIniFile.WriteBool('Proxy', 'Enabled', ProxyEnabled);
     MyIniFile.WriteString('Proxy', 'Hostname', ProxyHostname);
     MyIniFile.WriteString('Proxy', 'Port', ProxyPort);
     MyIniFile.WriteString('Proxy', 'Username', ProxyUsername);
     MyIniFile.WriteString('Proxy', 'Password', ProxyPassword);
end;


procedure TMainForm.AboutSubMenuClick(Sender: TObject);
begin
     AboutForm.ShowModal;
end;

procedure TMainForm.SaveHTMLSourceToFile(const FileName: string; WB: TWebBrowser);
var
  PersistStream: IPersistStreamInit;
  FileStream: TFileStream;
  Stream: IStream;
  SaveResult: HRESULT;

begin
     PersistStream := WB.Document as IPersistStreamInit;
     FileStream := TFileStream.Create(FileName, fmCreate);
     try
        Stream := TStreamAdapter.Create(FileStream, soReference) as IStream;
        SaveResult := PersistStream.Save(Stream, True);
        If FAILED(SaveResult) Then
           MessageBox(Handle, 'Fail to save HTML source', 'Error', 0);
     finally
    { we are passing soReference to TStreamAdapter contructor parameter,
      it is our reponsibility to destroy the stream object. }
        FileStream.Free;
     end;
end;

procedure TMainForm.SaveToDiskSubMenuClick(Sender: TObject);
begin
     If (SaveDialog.Execute) Then
        SaveHTMLSourceToFile(SaveDialog.Filename, WebBrowser);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     If MessageDlg('Do you really want to exit?', mtConfirmation, [mbYes, mbNo], 0) = mrYes Then
     Begin
          If (HookID <> 0) Then UnHookWindowsHookEx(HookID);
          MainForm.WriteIniFile(Sender);
          MyIniFile.Free;
          WebBrowser.Stop;
          NagiosDocForm.NagiosDocWebBrowser.Stop;
          Action:=caFree;
     end
     else Action:=caNone;
end;

procedure TMainForm.ShowToolbarSubMenuClick(Sender: TObject);
begin
     If Not Toolbar.Visible Then
     Begin
          Toolbar.Show;
          ShowToolbarSubMenu.Checked:=True;
     end
     else
     Begin
          Toolbar.Hide;
          ShowToolbarSubMenu.Checked:=False;
     end;
end;

procedure TMainForm.ShowMainMenuSubMenuClick(Sender: TObject);
Var I: Integer;
begin
     If MainMenu.Items[0].Visible Then
     Begin
          ShowMainMenuSubMenu.Checked:=False;
          For I:=0 to MainMenu.Items.Count-1 do
              MainMenu.Items[I].Visible:=False;
     end
     else
     Begin
          ShowMainMenuSubMenu.Checked:=True;
          For I:=0 to MainMenu.Items.Count-1 do
              MainMenu.Items[I].Visible:=True;
     End;

end;

procedure TMainForm.ShowStatusbarSubMenuClick(Sender: TObject);
begin
     If Not Statusbar.Visible Then
     Begin
          Statusbar.Show;
          ShowStatusbarSubMenu.Checked:=True;
     end
     else
     begin
          Statusbar.Hide;
          ShowStatusbarSubMenu.Checked:=False;
     end;
end;

procedure TMainForm.NetworkOutagesToolButtonClick(Sender: TObject);
begin
     NetworkOutagesToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     NetworkOutagesSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'outages.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostProblemsToolButtonClick(Sender: TObject);
begin
     HostProblemsToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostProblemsSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServiceProblemsToolButtonClick(Sender: TObject);
begin
     ServiceProblemsToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServiceProblemsSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all&servicestatustypes=28';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServiceGroupSummaryToolButtonClick(Sender: TObject);
begin
     ServiceGroupSummaryToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServiceGroupSummarySubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?servicegroup=all&style=summary';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostgroupSummaryToolButtonClick(Sender: TObject);
begin
     HostgroupSummaryToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostgroupSummarySubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=summary';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.HostDetailToolButtonClick(Sender: TObject);
begin
     HostDetailToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     HostDetailSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?hostgroup=all&style=hostdetail';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.ServiceDetailToolButtonClick(Sender: TObject);
begin
     ServiceDetailToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     ServiceDetailSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'status.cgi?host=all';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.TacticalOverviewToolButtonClick(Sender: TObject);
begin
     TacticalOverviewToolButton.Down:=True;
     ClearCheckedMenuSubItems;
     TacticalOverviewSubMenu.Checked:=True;
     MainForm.CurrentURL:=NagiosCGIURL+'tac.cgi';
     WebBrowser.Navigate(MainForm.CurrentURL);
end;

procedure TMainForm.NagiosDocumentationSubMenuClick(Sender: TObject);
begin
     If (NagiosDocumentationSubMenu.Checked) Then
     Begin
          If Not NagiosDocForm.Focused Then
          Begin
               NagiosDocForm.SetFocus;
          end
          else
          Begin
               NagiosDocumentationSubMenu.Checked:=False;
               NagiosDocForm.Hide;
          end;
     end
     else
     Begin
          NagiosDocumentationSubMenu.Checked:=True;
          NagiosDocForm.Show;
     end;
end;

procedure TMainForm.NagiosWebsiteSubMenuClick(Sender: TObject);
begin
     ShellExecute(Handle, 'open', 'http://www.nagios.org', nil, nil, SW_SHOWNORMAL);
end;


procedure TMainForm.ExecuteExternalURL(URL: String);
begin
     If (URL <> '') Then
        ShellExecute(Handle, 'open', PAnsiChar(URL), nil, nil, SW_SHOWNORMAL);
end;


procedure TMainForm.EnableMenuAndToolbarButtons(Sender: TObject);
var i: Integer;
begin
     For I:=0 to ToolBar.ButtonCount-1 do
         ToolBar.Buttons[I].Enabled:=True;

     For I:=0 to FileMenu.Count-1 do
         FileMenu.Items[I].Enabled:=True;
     For I:=0 to NagiosMenu.Count-1 do
         NagiosMenu.Items[I].Enabled:=True;
     For I:=0 to MonitoringMenu.Count-1 do
         MonitoringMenu.Items[I].Enabled:=True;
     For I:=0 to ReportingMenu.Count-1 do
         ReportingMenu.Items[I].Enabled:=True;

     RefreshToolButton.Enabled:=True;
     RefreshToolButton.ImageIndex:=2;
     RefreshToolButton.Hint:='Refresh current view';
     RefreshSubMenu.Caption:='&Refresh';
     RefreshSubMenu.Enabled:=True;
     Refresh2SubMenu.Caption:='&Refresh';
     Refresh2SubMenu.Enabled:=True;

     NagiosDocumentationSubMenu.Enabled:=True;
end;


procedure TMainForm.DisableMenuAndToolbarButtons(Sender: TObject);
var i: Integer;
begin
     For I:=0 to ToolBar.ButtonCount-1 do
         ToolBar.Buttons[I].Enabled:=False;

     For I:=0 to FileMenu.Count-1 do
         FileMenu.Items[I].Enabled:=False;
     For I:=0 to NagiosMenu.Count-1 do
         NagiosMenu.Items[I].Enabled:=False;
     For I:=0 to MonitoringMenu.Count-1 do
         MonitoringMenu.Items[I].Enabled:=False;
     For I:=0 to ReportingMenu.Count-1 do
         ReportingMenu.Items[I].Enabled:=False;

     { Make Exit, Fullscreen and Nagios Website always enabled }
     NagiosWebsiteSubMenu.Enabled:=True;
     ConfigurationSubMenu.Enabled:=True;
     ExitSubMenu.Enabled:=True;

     FullScreenToolButton.Enabled:=True;
     ExitToolButton.Enabled:=True;

     If (NagiosWebURL <> '') or (NagiosCGIURL <> '') Then
     Begin
          RefreshToolButton.Enabled:=True;
          RefreshToolButton.ImageIndex:=11;
          RefreshToolButton.Hint:='Stop connection';
          RefreshSubMenu.Caption:='&Stop';
          RefreshSubMenu.Enabled:=True;
          Refresh2SubMenu.Caption:='&Stop';
          Refresh2SubMenu.Enabled:=True;
     end;

     NagiosDocumentationSubMenu.Enabled:=False;
end;

procedure TMainForm.UnSelectMenuAndToolbarButtons(Sender: TObject);
var i: Integer;
begin
     For I:=0 to ToolBar.ButtonCount-1 do
         ToolBar.Buttons[I].Down:=False;

     { Disable Everything Except FileMenu }
     For I:=0 to NagiosMenu.Count-1 do
         NagiosMenu.Items[I].Checked:=False;
     For I:=0 to MonitoringMenu.Count-1 do
         MonitoringMenu.Items[I].Checked:=False;
     For I:=0 to ReportingMenu.Count-1 do
         ReportingMenu.Items[I].Checked:=False;

     { Enable some }
     ConfigurationSubMenu.Enabled:=True;
     ExitSubMenu.Enabled:=True;

     FullScreenToolButton.Enabled:=True;
     ExitToolButton.Enabled:=True;

     If (NagiosWebURL <> '') or (NagiosCGIURL <> '') Then
     Begin
          RefreshToolButton.Enabled:=True;
          RefreshToolButton.ImageIndex:=11;
          RefreshToolButton.Hint:='Refresh current view';
          RefreshSubMenu.Caption:='&Refresh';
          Refresh2SubMenu.Caption:='&Refresh';
          Refresh2SubMenu.Enabled:=True;
          RefreshSubMenu.Enabled:=True;
     end;

     NagiosDocumentationSubMenu.Enabled:=False;
end;



end.
