{   Copyright (C) 2005  Hugo Monteiro (hvm_pt@users.sourceforge.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TConfigurationForm = class(TForm)
    OkButton: TButton;
    CancelButton: TButton;
    NagiosGroupBox: TGroupBox;
    NagiosWebURLEdit: TEdit;
    NagiosWebURLLabel: TLabel;
    NagiosCGIURLLabel: TLabel;
    NagiosCGIURLEdit: TEdit;
    NagiosUsernameLabel: TLabel;
    NagiosPasswordLabel: TLabel;
    NagiosUsernameEdit: TEdit;
    NagiosPasswordEdit: TEdit;
    ProxyGroupBox: TGroupBox;
    ProxyEnabledCheckBox: TCheckBox;
    ProxyHostnameLabel: TLabel;
    ProxyUsernameLabel: TLabel;
    ProxyHostnameEdit: TEdit;
    ProxyPortEdit: TEdit;
    ProxyUsernameEdit: TEdit;
    ProxyPasswordEdit: TEdit;
    ProxyPasswordLabel: TLabel;
    ProxyPortLabel: TLabel;
    Label1: TLabel;
    StartupPageComboBox: TComboBox;
    procedure ProxyEnabledCheckBoxClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ConfigurationForm: TConfigurationForm;

implementation

uses Unit1, Unit4;

{$R *.dfm}

procedure TConfigurationForm.ProxyEnabledCheckBoxClick(Sender: TObject);
begin
     If (ProxyEnabledCheckBox.Checked) Then
     Begin
          ProxyHostnameEdit.Enabled:=True;
          ProxyPortEdit.Enabled:=True;
          ProxyUsernameEdit.Enabled:=True;
          ProxyPasswordEdit.Enabled:=True;
          ProxyHostnameEdit.SetFocus;
     end
     else
     Begin
          ProxyHostnameEdit.Enabled:=False;
          ProxyPortEdit.Enabled:=False;
          ProxyUsernameEdit.Enabled:=False;
          ProxyPasswordEdit.Enabled:=False;
          ProxyEnabledCheckBox.SetFocus;
     end;
end;

procedure TConfigurationForm.FormActivate(Sender: TObject);
var Port: Integer;
    Proxy: String;
begin
    NagiosWebURLEdit.Text:=MainForm.NagiosWebURL;
    NagiosCGIURLEdit.Text:=MainForm.NagiosCGIURL;
    NagiosUsernameEdit.Text:=MainForm.NagiosUsername;
    NagiosPasswordEdit.Text:=MainForm.NagiosPassword;
    ProxyEnabledCheckBox.Checked:=MainForm.ProxyEnabled;
    ProxyHostnameEdit.Text:=MainForm.ProxyHostname;
    ProxyPortEdit.Text:=MainForm.ProxyPort;
    ProxyUsernameEdit.Text:=MainForm.ProxyUsername;
    ProxyPasswordEdit.Text:=MainForm.ProxyPassword;
    StartupPageComboBox.ItemIndex:=StartupPageComboBox.Items.IndexOf(MainForm.StartupPage);

    GetProxyServer('http', Proxy, Port);
    ProxyHostnameEdit.Text:=Proxy;
    ProxyPortEdit.Text:=IntToStr(Port);
end;

procedure TConfigurationForm.FormCreate(Sender: TObject);
begin
     Height:=200;
end;

end.
