{   Copyright (C) 2005  Hugo Monteiro (hvm_pt@users.sourceforge.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit Unit4;

interface

function GetProxyInformation: string;

procedure GetProxyServer(protocol: string; var ProxyServer: string; var ProxyPort: Integer);

implementation

uses WinInet, SysUtils;

function GetProxyInformation: string;
var
  ProxyInfo: PInternetProxyInfo;
  Len: LongWord;
begin
  Result := '';
  Len := 4096;
  GetMem(ProxyInfo, Len);
  try
    if InternetQueryOption(nil, INTERNET_OPTION_PROXY, ProxyInfo, Len) then
      if ProxyInfo^.dwAccessType = INTERNET_OPEN_TYPE_PROXY then
      begin
        Result := ProxyInfo^.lpszProxy
      end;
  finally
    FreeMem(ProxyInfo);
  end;
end;

{**************************************************************************
* NAME:    GetProxyServer
* DESC:    Proxy-Server Einstellungen abfragen
* PARAMS:  protocol => z.B. 'http' or 'ftp'
* RESULT:  [-]
* CREATED: 08-04-2004/shmia
*************************************************************************}
procedure GetProxyServer(protocol: string; var ProxyServer: string;
 var ProxyPort: Integer);
var
  i: Integer;
  proxyinfo, ps: string;
begin
  ProxyServer := '';
  ProxyPort := 0;

  proxyinfo := GetProxyInformation;
  if proxyinfo = '' then
    Exit;

  protocol := protocol + '=';

  i := Pos(protocol, proxyinfo);
  if i > 0 then
  begin
    Delete(proxyinfo, 1, i + Length(protocol));
    i := Pos(';', ProxyServer);
    if i > 0 then
      proxyinfo := Copy(proxyinfo, 1, i - 1);
  end;

  i := Pos(':', proxyinfo);
  if i > 0 then
  begin
    ProxyPort := StrToIntDef(Copy(proxyinfo, i + 1, Length(proxyinfo) - i), 0);
    ProxyServer := Copy(proxyinfo, 1, i - 1)
  end
end;

{
procedure TForm.Button1Click(Sender: TObject);
var
  ProxyServer: string;
  ProxyPort: Integer;
begin
  GetProxyServer('http', ProxyServer, ProxyPort);
  Label1.Caption := ProxyServer;
  label2.Caption := IntToStr(ProxyPort);
end;
}
end.
 