{   Copyright (C) 2005  Hugo Monteiro (hvm_pt@users.sourceforge.net)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, OleCtrls, SHDocVw, Buttons;

type
  TNagiosDocForm = class(TForm)
    NagiosDocWebBrowser: TWebBrowser;
    Panel1: TPanel;
    CloseButton: TButton;
    StayOnTopCheckBox: TCheckBox;
    DocHomeButton: TBitBtn;
    PreviousButton: TBitBtn;
    NextButton: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure StayOnTopCheckBoxClick(Sender: TObject);
    procedure NagiosDocWebBrowserBeforeNavigate2(Sender: TObject;
      const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
      Headers: OleVariant; var Cancel: WordBool);
    procedure FormShow(Sender: TObject);
    procedure DocHomeButtonClick(Sender: TObject);
    procedure PreviousButtonClick(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
    procedure NagiosDocWebBrowserCommandStateChange(Sender: TObject;
      Command: Integer; Enable: WordBool);
  private
    { Private declarations }
    CurrentURL: String;
    HistoryForward, HistoryBack: Boolean;
  public
    { Public declarations }
  end;

  function MouseProc2(nCode: Integer; wParam, lParam: Longint): Longint; stdcall;

var
  NagiosDocForm: TNagiosDocForm;
  HookID2: THandle;

implementation

{$R *.dfm}

uses Unit1;

function MouseProc2(nCode: Integer; wParam, lParam: Longint): Longint; stdcall;
var
  szClassName: array[0..255] of Char;
  MausPos: TPoint;
  X, Y: Integer;
const
  ie_name = 'Internet Explorer_Server';
begin
  GetCursorPos(MausPos);
  x := MausPos.x;
  y := MausPos.y;

  case nCode < 0 of
    True:
      Result := CallNextHookEx(HookID, nCode, wParam, lParam)
      else
        case wParam of
          WM_RBUTTONDOWN,
          WM_RBUTTONUP:
            begin
              GetClassName(PMOUSEHOOKSTRUCT(lParam)^.HWND, szClassName, SizeOf(szClassName));
              if lstrcmp(@szClassName[0], @ie_name[1]) = 0 then
              begin
                Result := HC_SKIP;
                // PopupMenu.popup(X, Y);
              end
              else
                Result := CallNextHookEx(HookID, nCode, wParam, lParam);
            end
            else
              Result := CallNextHookEx(HookID, nCode, wParam, lParam);
        end;
  end;
end;


procedure TNagiosDocForm.FormCreate(Sender: TObject);
begin
//     HookID2:=SetWindowsHookEx(WH_MOUSE, MouseProc2, 0, GetCurrentThreadId());
     NagiosDocForm.StayOnTopCheckBox.Checked:=MainForm.NagiosDocStayOnTop;
     CurrentURL:=MainForm.NagiosWebURL+'docs/index.html';
     NagiosDocForm.NagiosDocWebBrowser.Navigate(NagiosDocForm.CurrentURL);
     HistoryForward:=False;
     HistoryBack:=False;
end;

procedure TNagiosDocForm.FormDestroy(Sender: TObject);
begin
//     If (HookID2<>0) Then UnHookWindowsHookEx(HookID2);
end;

procedure TNagiosDocForm.CloseButtonClick(Sender: TObject);
begin
     MainForm.NagiosDocumentationSubMenu.Checked:=False;
     NagiosDocForm.Close;
end;

procedure TNagiosDocForm.FormActivate(Sender: TObject);
begin
     {use our own popup menu in a TWebBrowser component}
     HookID2:=SetWindowsHookEx(WH_MOUSE, MouseProc2, 0, GetCurrentThreadId());
end;

procedure TNagiosDocForm.StayOnTopCheckBoxClick(Sender: TObject);
begin
     If (StayOnTopCheckBox.Checked) Then
     Begin
          NagiosDocForm.FormStyle:=fsStayOnTop;
          NagiosDocForm.NagiosDocWebBrowser.Navigate(CurrentURL);
     end
     else
     Begin
          NagiosDocForm.FormStyle:=fsNormal;
          NagiosDocForm.NagiosDocWebBrowser.Navigate(CurrentURL);
     end;
end;

procedure TNagiosDocForm.NagiosDocWebBrowserBeforeNavigate2(
  Sender: TObject; const pDisp: IDispatch; var URL, Flags, TargetFrameName,
  PostData, Headers: OleVariant; var Cancel: WordBool);
begin
     If (URL = '') Then
     Begin
          Cancel:=False;
          Exit;
     end;
     If (MainForm.NagiosWebURL = '') Then
     Begin
          MainForm.DisableMenuAndToolbarButtons(Sender);
          Cancel:=False;
          Exit;
     end;
     If (MainForm.NagiosCGIURL = '') Then
     Begin
          MainForm.DisableMenuAndToolbarButtons(Sender);
          Cancel:=False;
          Exit;
     end;
     // Intercept ALL outside URLs and call the default browser
     If (Copy(URL, 0, Length(MainForm.NagiosWebURL)) <> MainForm.NagiosWebURL) Then
     Begin
          MainForm.ExecuteExternalURL(URL);
          Cancel:=True;
          Exit;
     end
     else CurrentURL:=URL;
end;

procedure TNagiosDocForm.FormShow(Sender: TObject);
begin
     If (MainForm.NagiosWebURL <> '') or (MainForm.NagiosCGIURL <> '') Then
          NagiosDocForm.NagiosDocWebBrowser.Navigate(NagiosDocForm.CurrentURL);
end;

procedure TNagiosDocForm.DocHomeButtonClick(Sender: TObject);
begin
     If (MainForm.NagiosWebURL <> '') or (MainForm.NagiosCGIURL <> '') Then
     Begin
          CurrentURL:=MainForm.NagiosWebURL+'docs/index.html';
          NagiosDocForm.NagiosDocWebBrowser.Navigate(NagiosDocForm.CurrentURL);
     end;
end;

procedure TNagiosDocForm.PreviousButtonClick(Sender: TObject);
begin
     NagiosDocForm.NagiosDocWebBrowser.GoBack;
end;

procedure TNagiosDocForm.NextButtonClick(Sender: TObject);
begin
     NagiosDocForm.NagiosDocWebBrowser.GoForward;
end;

procedure TNagiosDocForm.NagiosDocWebBrowserCommandStateChange(
  Sender: TObject; Command: Integer; Enable: WordBool);
begin
     case Command of
          CSC_NAVIGATEBACK: PreviousButton.Enabled:=Enable;
          CSC_NAVIGATEFORWARD: NextButton.Enabled:=Enable;
     end;
end;

end.
