<?php

/*
 * Nagios PHP Interface: perfinfo.php
 * 2004 Eldad Zack

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

function put_min(&$current,$candidate)
{
	if ($candidate < $current)
	{
		$current = $candidate;
	}
}

function put_max(&$current,$candidate)
{
        if ($candidate > $current)
        {
                $current = $candidate;
        }
}

function put_statistics(&$stem,$value)
{
	$stem['total'] += $value;
	put_max($stem['max'],$value);
        put_min($stem['min'],$value);
}

function init_statistics(&$stem)
{
	$stem['total'] = 0;
	$stem['max'] = 0;
	$stem['min'] = 0;
}

#
# Read status file
#

$status = file ($nagios->statusfile);

$perf_array = array();

init_statistics($perf_array['active']['exectime']);
init_statistics($perf_array['active']['latency']);
init_statistics($perf_array['active']['statechange']);
init_statistics($perf_array['passive']['statechange']);
$perf_array['active']['count'] = 0;
$perf_array['passive']['count'] = 0;

$mytime = time();

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		$active_checks = $field[9];
		$passive_checks = $field[10];
		$latency = $field[22];
		$exectime = $field[23];
		$statechange = $field[26];
		$last_check = $field[6];
		$completiontime = $mytime - $last_check;

		if ($active_checks)
		{
			$perf_array['active']['count'] ++;
			put_statistics($perf_array['active']['exectime'],$exectime);
			put_statistics($perf_array['active']['latency'],$latency);
			put_statistics($perf_array['active']['statechange'],$statechange);

			if ($completiontime <= 60) { $perf_array['active']['complete']['1min'] ++; }
			if ($completiontime <= 300) { $perf_array['active']['complete']['5min'] ++; }
			if ($completiontime <= 900) { $perf_array['active']['complete']['15min'] ++; }
			if ($completiontime <= 3600) { $perf_array['active']['complete']['hour'] ++; }
			if ($last_check > $progstart) { $perf_array['active']['complete']['progstart'] ++; }
		}
		elseif ($passive_checks)
		{
			$perf_array['passive']['count'] ++;
			put_statistics($perf_array['passive']['statechange'],$statechange);

			if ($completiontime <= 60) { $perf_array['passive']['complete']['1min'] ++; }
			if ($completiontime <= 300) { $perf_array['passive']['complete']['5min'] ++; }
			if ($completiontime <= 900) { $perf_array['passive']['complete']['15min'] ++; }
			if ($completiontime <= 3600) { $perf_array['passive']['complete']['hour'] ++; }
			if ($last_check > $progstart) { $perf_array['passive']['complete']['progstart'] ++; }
		}

	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$date = date("D M d H:i:s Y T",$reg[1]);
		$progstart = $field[1];
	}
}

$nagios->print_header("Performance Information",true);

#Infobox

$blacksmith->assign("date",$date);
$blacksmith->assign("username",$nagios->username);
$blacksmith->assign("refresh_rate",$nagios->config['refresh_rate']);

$blacksmith->assign("perf_array",$perf_array);
$blacksmith->display("perfinfo.tpl");

$blacksmith->display("nagios-footer.tpl");

?>