<?php

/*
 * Nagios PHP Interface: queue.php
 * 2004 Eldad Zack
 *
 * TODO: add service and host filter apropriate to the contactgroups
 * TODO: add sorting
 * TODO: add command links

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

#
# Read status file
#

$status = file ($nagios->statusfile);

$queue_array = array();

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		# push every service into an array, later to be popped and displayed.

		$service_name = $field[2];
		#if (!preg_match($filter_service,$service_name)) continue;

		$host_name = $field[1];
		#if (!preg_match($filter_host,$host_name)) continue;

		## Construct info

		$active_checks = $field[9];

		if (($last_check = $field[6])==0) $last_check = "Never";
		else $last_check = date("d/m/Y H:i:s",$last_check);

		if (($next_check = $field[7])==0) $next_check = "Never";
		else $next_check = date("d/m/Y H:i:s",$next_check);

		$queue_array_element["host_name"]=$host_name;
		$queue_array_element["service_name"]=$service_name;
		$queue_array_element["last_check"]=$last_check;
		$queue_array_element["next_check"]=$next_check;
		$queue_array_element["active_checks"]=$active_checks;

		$queue_array[$next_check] = $queue_array_element;
	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$date = date("D M d H:i:s Y T",$reg[1]);
	}
}

ksort($queue_array);

$nagios->print_header("Scheduling Queue",true);

#Infobox

$blacksmith->assign("date",$date);
$blacksmith->assign("username",$nagios->username);
$blacksmith->assign("refresh_rate",$nagios->config['refresh_rate']);

#
# Show me the money
#

$blacksmith->assign("queue_array",$queue_array);
$blacksmith->display("queue.tpl");

$blacksmith->display("nagios-footer.tpl");

?>