#
# gothix::capstderr - capture application stderr output to file
# 22-Nov-2004/shj
#
# Copyright (C) Stig H. Jacobsen & Gothix 2000-2004
#
# E-mail: capstderr@gothix.biz
#
#
# NOTES
# -----
#  - Just 'use' this and you won't see stderr output until exit().
#  - This module is a bit bothersome to syntax check and find errors
#    in, as many Perl errors will end up in the file.
#
#


package gothix::capstderr;


# --- Standard & CPAN modules ---------------------------------------------

use strict;
use warnings;


# --- BEGIN() -------------------------------------------------------------

our $_fn_stderr = undef;

#Redirect stderr to file to capture perl warnings and such
#This used to be in a BEGIN, but then Perl syntax errors (fatal)
#would be hidden too and not shown as the script was aborted

our $me = $0; $me =~ s!^.*/!!g; $me =~ s!\..*$!!g; # less path & ext

$_fn_stderr = "/tmp/stderr.$me.$ENV{LOGNAME}.$$";
open(ERRSAVE, ">&STDERR");
open(STDERR, ">$_fn_stderr") || fatal("Open $_fn_stderr for writing: $!");

our $truth_return = 42;


# --- END() ---------------------------------------------------------------

END {

   if (defined( $_fn_stderr )) {

      #Restore, close file
      close(STDERR);
      open(STDERR, ">&ERRSAVE");
      close(ERRSAVE);

      if ($_fn_stderr && -s $_fn_stderr) {
         open(F, $_fn_stderr) || print STDERR "Uhuh, can't open $_fn_stderr?! ($!)\n";   #double-fault..
         my @slurp = <F>;
         close(F);
         print STDERR "\n***** Error-output from $me *****\n";
         print STDERR @slurp, "\n";
      }

      unlink($_fn_stderr) 
   }

} #END


# --- Done ----------------------------------------------------------------


__END__

# $Id: nsc.pl 2008 2004-11-22 17:17:20Z shj $
# $HeadURL$
# vim:aw:
