#
# cpusage.pm - measure cpu load of this process
# 13-Nov-2001/shj
#
# Copyright (C) Stig H. Jacobsen & Gothix 2001-2005
#
# E-mail: input@gothix.biz
#


package gothix::cpusage;


# --- Mods ----------------------------------------------------------------

use Time::HiRes qw( time );

use strict;
use warnings;


# -------------------------------------------------------------------------

our $StartTime = time();

return 42;      #module truthful return


# --- Functions, not methods ----------------------------------------------

#all cpu time used + starting time of app
sub cpu_time {

   my ($user,$system,$cuser,$csystem) = times;
   my $sum = $user+$system+$cuser+$csystem;
   return wantarray ? ($sum,$StartTime) : $sum;

} #cpu_time


# --- start() -------------------------------------------------------------

sub start {
   my ($this) = @_;
   $this->{initial_time} = time();
   $this->{initial_cpu} = cpu_time();
   $this->iter_start();
} #start

sub reset { start(@_); }


# --- Constructor ---------------------------------------------------------

sub new {

   my $class = shift;
   my $this = {};
   bless $this, $class;

   $this->start();

   return $this;

} #new


# --- read() --------------------------------------------------------------

sub read {

   my ($this) = @_;

   my($nTime,$nCpu) = (time(),cpu_time());

   $nTime -= $this->{initial_time};
   $nCpu -= $this->{initial_cpu};

   my $percent;
   if ($nTime > 0) {    #no div0 please
      $percent = $nCpu / ($nTime / 100);
   } else {
      $percent = 'n/a';
   }

   if ($percent > 100) {
      #printf(STDERR "cpu usage percent exceeds 100%% ... %.2f\n", $percent);
      $percent = 100;      # hmm... (hide fact from user)
   }
   my $s = sprintf("%.2f%%", $percent);
   return $s;

} #read


# --- ...  ----------------------------------------------------------------
#
sub pretty_read {
   my($this) = @_;
   my $p = $this->read();
   my $s;
   $p =~ /^(\d+\.\d+)/;
   if ($1 < 1.0) {
      $p = 'z' x (int($1 * 5)+1);
      # $p = 'snooze ';
      #$p .= "($1)";
   }
   return $p;
} #pretty_read


# --- Iteration support (glue?) ----------------------------------------------------------------------
#
#my $cc = new gothix::cpusage;
#$cc->iter_start();
#while (blabla)
#   (do something that you don't know timings for)
#   $cc->iter_ate();
#print "cpu time used per iteration: ", $cc->iter_read(), "\n";

sub iter_start {

   my ($this) = @_;

   $this->{num_iter} = 0;

}

sub iter_ate {

   my ($this) = @_;

   $this->{num_iter}++;

}

sub iter_read {

   my ($this) = @_;

   return '?zdiv?' if !$this->{num_iter};
   return (cpu_time() - $this->{initial_cpu}) / $this->{num_iter};

}


# -------------------------------------------------------------------------

__END__
# $Id: cpusage.pm,v 1.7 2003/01/09 15:20:20 shj Exp $
# vim:aw:
