#!/bin/perl -w
#
# gothix::misc.pm - various, diverse, varied perl code and stuff
#
# Copyright (C) Stig H. Jacobsen & Gothix 2004
#
# 011101shj 


# --- Changes -------------------------------------------------------------


# --- Bugs ----------------------------------------------------------------


# --- TODO ----------------------------------------------------------------
#  - inline applicable subs - see man perlsub, /inline


# --- Code ----------------------------------------------------------------

package gothix::misc;

require Exporter;
our @ISA = qw( Exporter );

use strict;
use warnings;
use Carp;
use Sys::Hostname;
use Time::HiRes qw( );
use FindBin qw($Bin);


# --- Globals -------------------------------------------------------------

our @EXPORT_OK = qw(
   &inode
   &rpad
);

our @EXPORT = qw( 
              @montab @montab_long @daytab_long 
              $gPublisher $gURL
              $gPathSep $gPath      $gPgm $me
              $hostname $longhost
              $whoami
              &ctrl &numeric &all_digits
              &tdif &hostname &mtime &mmax &mmin &fix 
              &trim &array2hash &center
              &sqbytes &unsqbytes
              &done_percent &done_remain_secs &done_runtime &done_throughput
              &get_version
            );
our $VERSION = 0.01;

our @montab = (
   "Jan", "Feb", "Mar", "Apr", "May", "Jun",
   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" );

our @montab_long = (
   "January", "February", "March", "April", "May", "June",
   "July", "August", "September", "October", "November", "December" );

our @daytab_long = (
   'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
   'Friday', 'Saturday');

my %SZ = (
   'kb' => 1024,
   'mb' => 1024**2,
   'gb' => 1024**3,
   'tb' => 1024**4,
);

our $gPublisher = 'Gothix';
our $gURL      = 'http://www.gothix.biz';    #NOTE: NO trailing '/'

# w/o path, with extension
our $gPgm = $0;
#print "gpgm=$gPgm\n";
$gPgm =~ s!^.*/!!g;
#print "now gpgm=$gPgm\n";

our $gPathSep = '/';             #portability, sort of 

# full path & extension
our $gPath = $Bin . $gPathSep . $gPgm;

# no path, no extension
our $me = $gPgm;
$me =~ s!\..*$!!g;

our $longhost = hostname();
our $hostname = $longhost;
my $i = index(hostname(), '.');
$hostname = substr($longhost, 0, $i) if $i;        #loose domain

# Setup standard environment as needed, we may be in an unfriendly place
$ENV{LOGNAME} = "unknown-$>" unless $ENV{LOGNAME};

$ENV{'EDITOR'} = 'vi' unless $ENV{'EDITOR'};
$ENV{'VISUAL'} = $ENV{'EDITOR'} if !defined($ENV{'VISUAL'});
$ENV{'VISUAL'} = 'vi' if !defined($ENV{'VISUAL'});
$ENV{'PAGER'} = 'more' if !defined($ENV{'PAGER'});

our $whoami = $ENV{LOGNAME} . '@' . $hostname;

42;


# --- Publics -------------------------------------------------------------

# ctrl('A') returns control-a...
sub ctrl {
   return sprintf("%c", ord(uc($_[0]))-64);
}


sub mtime {
   return (stat($_[0]))[9];
} #mtime


#return inode of file
#also returns filesystem device for file, if called in array-context
sub inode {

   my @st = stat($_[0]) || return undef;
   return wantarray() ? ($st[1],$st[0]) : $st[1];

} #inode


sub mmax {
   my($a,$b) = @_;
   return $a if (!defined($b));
   return $b if (!defined($a));
   return ($a>$b)?$a:$b;
}

sub mmin {
   my($a,$b) = @_;
   return ($a<$b)?$a:$b;
}

#Convert simple array to a hash, values=1
sub array2hash {
   return map { $_ => 1 } @_;
} #array2hash


# --- longest() -----------------------------------------------------------
# Return the length() of longest item in array or array ref.
# $i = longest(@array);
# $i = longest(\@array);
#
sub longest {
   my $ary = (ref($_[0]) eq 'ARRAY') ? $_[0] : \@_;
   my $rval = 0;
   foreach $i (0..$#{$ary}) {
      my $ll = length($ary->[$i]);
      $rval = $ll if ($ll > $rval);
   }
   return $rval;
} #longest


# --- trim() --------------------------------------------------------------
# Remove all leading and trailing ws from string(s).

sub trim {

   my(@strings) = @_;

   foreach my $s (@strings) {
      #modifies @strings element
      #confess unless defined($s);
      $s =~ s/^\s+//;
      $s =~ s/[\r\n\s]+$//;
   }

   return wantarray ? @strings : $strings[0];

} #trim


# --- numeric() -----------------------------------------------------------
#
sub numeric ($) {
   return 0 if (!defined($_[0]) || ($_[0] eq ''));
   return ($_[0] =~ /^-{0,1}[\d\.]+$/);
}


sub all_digits ($) {
   return 0 if (!defined($_[0]) || ($_[0] eq ''));
   return ($_[0] =~ /^\d+$/);
}


# fixes argument to n digits
#  fix(23.90424444, 2) returns 23.90
sub fix {

   my($arg,$n) = @_;

   return int( $arg * (10**$n) ) / (10**$n);

} #fix

#improved version from nsc...
#nsc## --- tdif() --------------------------------------------------------------
#nsc## This is some of my weirder code
#nsc## Return difference between two time_t's as a string
#nsc## (ex. '1h23m40s'..)
#nsc#
#nsc#{ #brace to localize %sv
#nsc#
#nsc#   my %sv = (
#nsc#      'Y', 365*24*60*60,
#nsc#      'M', 30*24*60*60,
#nsc#      'W', 7*24*60*60,
#nsc#      'd', 24*60*60,
#nsc#      'h', 60*60,
#nsc#      'm', 60);
#nsc#
#nsc#   sub tdif {
#nsc#
#nsc#      my $dif;
#nsc#
#nsc#      return '*undef*' if (!$_[0] || !$_[1]);
#nsc#
#nsc#   #   #oh well..
#nsc#   #  $dif = ($_[0]>$_[1])?$_[0]-$_[1]:$_[1]-$_[0];                
#nsc#
#nsc#   # same shit, different code:
#nsc#      $dif = -$dif if ($dif<0);
#nsc#
#nsc#      return "now"
#nsc#         if ($dif == 0);
#nsc#
#nsc#      my $res = '';
#nsc#      my $details = 0;
#nsc#      foreach my $key ('Y','M','W','d','h','m') {
#nsc#         if ($dif > $sv{$key}) {
#nsc#            my $i = int($dif / $sv{$key});
#nsc#            $dif %= $sv{$key};
#nsc#            $res .= "${i}$key";
#nsc#            $details++;
#nsc#            }
#nsc#         last if ($details >= 2);
#nsc#         }
#nsc#      $res .= "${dif}s"
#nsc#         if (($dif > 0) && ($details < 2));
#nsc#      if (defined($_[2])) {   #wants just first element?
#nsc#         #retain only first component
#nsc#         $res = $1 if ($res =~ /^(\d+[a-z])\d/);
#nsc#         }
#nsc#      return $res;
#nsc#
#nsc#   } #tdif
#nsc#
#nsc#}


# This is some of my weirder code
# Return difference between two time_t's as a string
# (ex. '1h23m40s'..)
sub tdif {

   my $dif;

   return '*undef*' if (!defined($_[0]) || !defined($_[1]));

#   #oh well..
#  $dif = ($_[0]>$_[1])?$_[0]-$_[1]:$_[1]-$_[0];                

# same shit, different code:
# int() because the args may be calculated floating point values
# or from Time::Hires
   $dif = int($_[0]) - int($_[1]);
   $dif = -$dif if ($dif<0);

   return "now"
      if ($dif == 0);

   my $res = '';
   my %sv = (
      'Y', 365*24*60*60,
      'M', 30*24*60*60,
      'W', 7*24*60*60,
      'd', 24*60*60,
      'h', 60*60,
      'm', 60);
   my $details = 0;
   foreach my $key ('Y','M','W','d','h','m') {
      if ($dif >= $sv{$key}) {
         my $i = int($dif / $sv{$key});
         $dif %= $sv{$key};
         $res .= "${i}$key";
         $details++;
         }
      last if ($details >= 2);
      }
   $res .= "${dif}s"
      if (($dif > 0) && ($details < 2));
   if (defined($_[2])) {   #wants just first element?
      #retain only first component
      $res = $1 if ($res =~ /^(\d+[a-zA-Z])\d/);
      }
   return $res;

} #tdif


# -------------------------------------------------------------------------

#$str = center('mystr', 10);
#return centered string for field $wid chars wide, space-padded, left and right
sub center {

   my($str, $wid) = @_;

   confess __PACKAGE__ . '::center() No string supplied'
      unless defined( $str );
   confess __PACKAGE__ . "::center() No (valid) width ($wid) supplied"
      unless (defined( $wid ) and all_digits( $wid ));

   my $len = length($str);
   return substr($str, 0, $wid) if ($len >= $wid);    #already the wanted width or longer

   my $spc = int(($wid - $len) / 2);
#nah?#   $spc = 1 unless ($spc > 0);

   my $res = (' ' x $spc) . $str;

   $res .= ' ' x ($wid - length($res))
      if (length($res) < $wid);

   return $res;

} #center


# -------------------------------------------------------------------------
# $str = rpad('mystr', 10);
# Right-pad string with spaces to make it N chars wide
sub rpad {

   my $l = length($_[0]);
   return $_[0] if ($l >= $_[1]);
   return $_[0] . (' ' x ($_[1] - $l));

} #rpad


# --- Conversion -----------------------------------------------------

# --- sqbytes() ---
# Input: Integer, bytes
# Returns: Bytes converted to size qualified amount (3.6 GB)
sub sqbytes {

   my ($i) = @_;

   return '' unless (defined($i) && ($i ne ''));

   croak "'$i' isn't numeric?!"
      unless ($i =~ /^[-\.\d]+$/);

   foreach my $sq ('tb', 'gb', 'mb', 'kb') {
      if ($i >= $SZ{$sq}) {
         my $res = $i / $SZ{$sq};
         my $fmt;
         if ($res < 10) {
            if ($res < 3) {
               $fmt = "%.2f";
            } else {
               $fmt = "%.1f";
            }
         } else {
            $fmt = '%d';
         }
         return sprintf($fmt ." $sq", $res);
      }
   }
   #less than 1kb, snippet the '0' from '0.23'
   #my $s = substr( sprintf('%.2f kb', $i / 1024), 1 );
   my $s = sprintf('%.2f kb', $i / 1024);
#   my $s = sprintf('%d byt', int($i));
   #$s =~ s/\.0+$//; #no difference
   return $s;

} #sqbytes


# --- unsqbytes() ---
# Input: String with size qualifier, '2.34 gb'
# Returns: String converted to bytes
sub unsqbytes {

   my ($s) = @_;

   return undef unless (defined($s) && ($s ne ''));

   return $s if all_digits($s);     #no need to unsquify

   $s =~ /^\s*([\d\.]+)\s*([a-z]*)\s*$/ || return undef;
   my $amt = $1;
   my $sq = lc($2);
   #d("unsqbytes($s): Got '$amt' and '$sq'..");

   return $amt if ($sq eq 'byt');

   if (defined($SZ{$sq})) {
      return $amt * $SZ{$sq};
   }

   print(STDERR "unsqbytes($s): Can't unsqfy '$sq'\n");
   return undef;

} #unsqbytes


# -------------------------------------------------------------------------
# TODO: OO'rize this

#doesn't append '%' as callee may want to do math on the percentage
sub done_percent {

   my ($total, $sofar) = @_;

   return 0 unless ($total && $sofar);

   my $pct = $sofar / ($total / 100);
   return sprintf('%.2f', $pct);

} #done_percent


sub done_remain_secs {

   my ($started, $total, $sofar) = @_;

   return undef unless ($total && $sofar);

   my $pct = done_percent($total, $sofar);
   return undef if ($pct == 0);

   my $runtm = done_runtime($started);
   my $secs_per_pct = $runtm / $pct;
   my $secs_remain = ($secs_per_pct * 100) - $runtm;

   return $secs_remain;

}


sub done_runtime {

   my ($started) = @_;

   return Time::HiRes::time() - $started;

} #done_runtime


sub done_throughput {

   my ($started,$bytes_moved) = @_;

   my $runtm = done_runtime($started);
   my $perf = sqbytes( ($bytes_moved / $runtm) * 60 ) . "/min";
   return $perf;

} #done_throughput


# -------------------------------------------------------------------------

sub get_version {

   my ($name_tag, $id_tag) = @_;

   my @c = split(/\s+/, $id_tag);
   #$c[2] =~ /^\d+\.\d+$/)
   $VERSION = $c[2];

   my $CVS_TAG = '(unreleased)';
   if ($name_tag =~ /Name:\s(.+)\s\$/) {
      $CVS_TAG = $1;
   }

   return ($VERSION, $CVS_TAG);

} #get_version


# -------------------------------------------------------------------------


__END__

# $Id: misc.pm,v 1.5 2004/11/15 16:20:31 shj Exp $
# vim:aw:
