#
# gothix::oobase -- common utility base methods for Perl OO-classes, or so
#
# Copyright Stig H. Jacobsen & Gothix 2002-2005
#


# --- POD prologue --------------------------------------------------------

=pod 

=head1 gothix::oobase

gothix::oobase -- common utility base methods for Perl OO-classes, or so

=head1 SYNOPSIS

TODO!


=head1 DESCRIPTION

Features:

=over 3

=item Good thing #1

=item Good thing #1

=back

(more description of features, overview, etc. (sales talk))


=head1 Exported symbols

None.


=cut


# --- Modules -------------------------------------------------------------

package gothix::oobase;

use strict;
use warnings;
use Exporter;
use Carp;
eval "use Data::Dumper;";     #debug
if ($@) {
   sub Dumper {
      return "@_ (Data::Dumper is N/A!!)";
   }
}

#use gothix::misc;


# --- Globals -------------------------------------------------------------

#module truth return, aka '42', 'return 42', etc.
my $this_module_really_returns_a_true_value_and_all_is_well = 42;


# --- Methods -------------------------------------------------------------

=pod

=head1 Class and object methods

(what can be done with/to the object)

=cut


# --- debug() -------------------------------------------------------------
# Enable/disable/query debug setting for object.

sub debug {

   my $this = shift;
   my $newval = shift;
   $this->{debug} = $newval
      if defined( $newval );
   return $this->{debug};

} #debug


# --- debug_setting() -- default debug setting ----------------------------

sub debug_setting {

   my $this = shift;

   return $ENV{OOBASE_DEBUG}
       if $ENV{OOBASE_DEBUG};

   my $pkg = ref($this);

   my $evar = 'DEBUG_' . uc($pkg);
   $evar =~ s/::/_/g;

   #print STDERR "looking for evar '$evar'\n";

   return defined($ENV{$evar}) ? 1 : 0;

} #debug_setting


# --- debug_init() --------------------------------------------------------
# $this->debug_init([$debug_enabled])
# Sets up debugging for object as per debug_settings() and such.

sub debug_init {

   my $this = shift;
   my $pkg = shift;
   my $val = @_ ? shift : 0;

   my $dfl = $this->debug_setting($pkg);
   $this->{debug} = $dfl ? $dfl : $val;

} #debug_init


# --- d() -- debug output -------------------------------------------------

sub d {

   my ($this,@msg) = @_;

   return unless $this->{debug};

   #many objects have a name
   if ($this->{name}) {
      print STDERR $this->{name}, ': ';
   } else {
      print STDERR ref($this), ': ';
   }
   print STDERR @msg, "\n";

} #d


# --- bug() -- report problem, terminate application ----------------------

=pod 

=head2 C<bug($message)>

Confess with the given message, terminating the application.

The method never returns.

=cut

# TODO: we may want to cleanup (close driver) and such ..
sub bug {

   my $this = shift;

   confess @_;    #a bit primitive for now

} #bug


# --- configure_assertions() ----------------------------------------------

=pod 

=head2 C<disable_assertions($bool)>

For performance reasons, assertions may be disabled at runtime with
this method. They are enabled by default.

=cut

sub disable_assertions {

   my $this = shift;
   my $val = shift;

   if (defined($val) and $val) {
      $this->{_disable_assertions} = 1;
   } else {
      delete $this->{_disable_assertions};
   }

} #disable_assertions


# --- assert() -- call bug() if assertion fails ---------------------------

=pod 

=head2 C<assert($res)>

Invoke the bug() if assertion fails.

   $console->assert($LINES >= 20);

The method may never return.

=cut

sub assert {

   my $this = shift;

   return if defined( $this->{_disable_assertions} );

   my $res = shift;
   my $message = shift || "Assertion fails";

   $this->bug($message)
      unless $res;

} #assert


# --- dump_object() -- print object to stderr -----------------------------

=pod 

=head2 C<dump_object([$message])>

Calls Data::Dumper() on the object, printing its output to stderr.

There is no return value.

=cut

sub dump_object {

   my $this = shift;
   #TODO: my $message = shift;

   {
      local $Data::Dumper::Maxdepth = 2;     #stuff it..
      print STDERR "\nObject dump:\n", Dumper($this), "\n(eod)\n";
   }

} #dump_object


# -------------------------------------------------------------------------
# TODO: move error setting/handling to ooerror or somesuch?


# -------------------------------------------------------------------------
# Returns the current error string, undef if no error.
sub geterr {

   my $this = shift;
   return defined($this->{error}) ? $this->{error} : undef;

} #geterr


# -------------------------------------------------------------------------
# _srERR('msg') - set & return error
# _srERR($message) - always returns undef, so we can:
#   return $this->_srERR(...)
sub _srERR {

   my $this = shift;
   $this->{error} = shift           #only set it, if no other error set
      unless $this->{error};
   return undef;

} #_srERR


# -------------------------------------------------------------------------
# _srOK($val) for:
#        return $this->_ok(42);
#      (clears {error} and returns 42 or just '1' (true) by default))
sub _srOK {

   my ($this,$val) = (shift,shift);
   delete $this->{error};
   return $val ? $val : 1;

} #_srOK


# --- Aux subs - NO METHODS BELOW HERE, ONLY SUBS -------------------------

=pod

=head1 Auxillary subroutines

(included, useful subs that aren't object methods)

(none)

=cut


# --- POD trailer ---------------------------------------------------------

=pod 

=head1 Object description

Additional keys that can be set in the object:

=over 3

=item debug

Set to any true value to cause object to print info to stderr.

=back

Example: C<$console->{debug} = 1;>  .. sets debugging on for C<$console>.

=cut


=head1 ENVIRONMENT

Set OOBASE_DEBUG to a true value to enable debugging in all objects.


=head1 DIAGNOSTICS

(error messages, debug abilities, self-dumping methods, etc.)


=head1 TODO

(future improvements to the class)


=head1 AUTHOR(S)

Written by Stig H. Jacobsen, input@gothix.dk, Apr-2005.


=head1 SEE ALSO

(other relevant modules, scripts, pod-pieces, etc.)


=head1 COPYRIGHT

Copyright Gothix & Stig H. Jacobsen 2004-2005.


=cut


# --- .. ------------------------------------------------------------------

__END__

# $Id: base.pm 2552 2005-04-18 14:56:12Z shj $
# $HeadURL: svn://dax/trunk/shj-devel/xsbs/console/base.pm $
# vim:aw:
#.
