#
# subversion.pm - gothix subversion supportive perl lib
# Copyright Stig H. Jacobsen & Gothix 2004
# 15-Nov-2004/shj from various apps & mods
#

package gothix::subversion;

use strict;
use warnings;

our(@ISA, @EXPORT, $VERSION);

require Exporter;
@ISA = qw( Exporter );
@EXPORT = qw( &svn_idtag &svn_release );


# --------------------------------------------------------------------
# svn_idtag()
# Given an expanded ..
#   $Id: strings.pm 1825 2004-11-15 21:10:03Z shj $
# .. subversion tag, a hashref is returned with various keys.
#   

sub svn_idtag {

   my ($idtag) = @_;

   my @f = split(/\s+/, $idtag);
   shift(@f);  #initial $Id ...
   return undef unless ($#f >= 3);

   my $i = 0;
   my $res = {};
   foreach ('filename', 'revision', 'date', 'time', 'user') {
      $res->{$_} = $f[$i];
      $i++;
   }

   #release 2239 -> 22.39
#   $res->{revver} = substr($res->{revision}, 0, -2) . '.' .
#                    substr($res->{revision}, -2);
   $res->{revver} = sprintf('%.2f', $res->{revision} / 100);

   return $res;

} #svn_idtag


# --------------------------------------------------------------------
# svn_release()
# Given an expanded ..
#   HeadURL: svn://dax/tags/shj-devel/sms-tools/kittest2/smstools_lib.pm $
#   '$HeadURL: svn://dax/tags/shj-devel/xsbs/r21mar05-10/lib/vars.pm $
# .. subversion url in tags, we return the tag name ('release', kittest2 here).
#   

sub svn_release {

   my($url) = @_;

   if ($url =~ m!/tags/!) {
      $url =~ m!/tags/shj-devel/[^/]+/([^/]+)/! || die "svn_release(): malformed url '$url'";
      return  $1;
   } else {
      return undef;
   }

} #svn_release


# --------------------------------------------------------------------

__END__
# $Id: strings.pm 1825 2004-11-15 21:10:03Z shj $
# vim:aw:
