#!/bin/sh
# nsc 0.80 primitive installation script
# 22-Nov-2004/shj

BASE=${1:-/usr/local}
APPL=nsc
MANSECT=1

if [ ! -d versions ]; then
   cd `dirname $0`
   if [ ! -d versions ]; then
      echo "Please change to the $APPL directory before installing."
      exit 1
   fi
fi

if [ ! -w "$BASE" ]; then
   echo "$BASE is not writeable, using \$HOME instead"
   BASE="$HOME"
fi

echo "Installing to $BASE - press Enter to start"
read ans

set -e   #croak on errors

DESTDIR="$BASE/$APPL"
[ -d "$DESTDIR" ] || mkdir "$DESTDIR"
if [ "`pwd`" = "$DESTDIR" ]; then
   echo "No need to copy, unpacked in $DESTDIR already"
else 
   tar cf - . | (cd "$DESTDIR"; tar xf -)
   echo "Application installed."
fi

MANPATH="$BASE/man/man$MANSECT"
MANPAGE="${APPL}.${MANSECT}"
if [ -f "$MANPAGE" -a -d $MANPATH ]; then
   cp -f "$MANPAGE" $MANPATH
   echo "Installed man-page to $MANPATH"
fi

LINK="$BASE/bin/$APPL"
SRCLINK="$BASE/$APPL/$APPL.pl"
echo "Create link as $LINK to point to $SRCLINK?"
echo -n "[Y/n]? "
read ans

if [ -z "$ans" -o "$ans" = "y" ]; then
   echo "Creating $LINK"
   rm -f "$LINK"        #in case there is a symlink..
   cat >"$LINK" <<EOF
#!/bin/sh
exec $SRCLINK \$*
EOF
   chmod a+rx "$LINK"
fi

echo ''
echo "***** Done - $APPL is now installed *****"
echo ''
exit 0

# $Id: install.sh 2605 2005-04-24 19:17:43Z shj $
# $HeadURL: svn://dax/tags/shj-devel/nsc/0.80b5-1/install.sh $
# vim:aw:
