<?php

/*
 * Nagios PHP Interface: extinfo.php
 * 2003-2004 Eldad Zack
 *
 * TODO: extinfo.cgi shows Nagios Proccess as default

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios php script init error.");
}

$info_array = array();

function add_info($title,$value)
{
	global $info_array;

	$element = array();

	$element['title']=$title;
	$element['value']=$value;

	array_push($info_array,$element);
}


# $type values:
# 1 = host
# 2 = service 

$status = file ($nagios->statusfile);

if (isset($_GET['host']))
{
	if (isset($_GET['service']))
	{
		$scanstr = "SERVICE;".$_GET['host'].";".$_GET['service'].";";
		$title = "Extended Service Information";
		$type = 2;
	}
	else
	{
		$scanstr = "HOST;".$_GET['host'].";";
		$title = "Extended Host Information";
		$type = 1;
	}
}

if (!isset($scanstr))
{
	$nagios->print_error("No Host/Service Specified<br>");
}
else
{
	$scanstr = "/".$nagios->escape_preg($scanstr)."/";
	foreach ($status as $statusline)
	{
		if (preg_match($scanstr,$statusline))
		{
			$statusinfo=explode(";",$statusline);
			last;
		}
	}
}

if (!isset($statusinfo))
{
	$nagios->print_error("No Such Host/Service<br>");
}

$nagios->print_header($title,true);

if (preg_match("/\[([0-9]*)\] HOST/",$statusinfo[0],$reg))
// Host
{
	add_info("Service Status",$statusinfo[2]);
	add_info("Plugin Output",$statusinfo[20]);
	add_info("Last Check Time",$nagios->datetime($statusinfo[3]));
	add_info("Last State Change",$nagios->datetime($statusinfo[4]));	
	add_info("Problem Acknowledged",$nagios->yesno($statusinfo[5]));
	add_info("Time UP",$statusinfo[6]);
	add_info("Time Down",$statusinfo[7]);
	add_info("Time Unreachable",$statusinfo[8]);
	add_info("Last Notification Time",$statusinfo[9]);
	add_info("Current Notification Number",$statusinfo[10]);
	add_info("Notifications Enabled",$nagios->yesno($statusinfo[11]));
	add_info("Event Handlers Enabled",$nagios->yesno($statusinfo[12]));
	add_info("Checks Enabled",$nagios->yesno($statusinfo[13]));
	add_info("Flap Detection Enabled",$nagios->yesno($statusinfo[14]));
	add_info("Host Is Flapping",$nagios->yesno($statusinfo[15]));
	add_info("Percent State Change",$statusinfo[16]);
	add_info("Scheduled Downtime Depth",$statusinfo[17]);
	add_info("Failure Prediction Enabled",$nagios->yesno($statusinfo[18]));
	add_info("Process Performance Date",$nagios->yesno($statusinfo[19]));

	$blacksmith->assign("host_name",$statusinfo[1]);
	$blacksmith->assign("info_array",$info_array);
	$blacksmith->display("extinfo-host.tpl");	
}
else
// Service
{
	add_info("Service Status",$statusinfo[3]);
	add_info("Plugin Output",$statusinfo[31]);
	add_info("Retry Number",$statusinfo[4]);
	add_info("State Type",$statusinfo[5]);
	add_info("Last Check Time",$nagios->datetime($statusinfo[6]));
	add_info("Next Check Time",$nagios->datetime($statusinfo[7]));
	add_info("Check Interval",(($statusinfo[7]-$statusinfo[6])/60)." Minute(s)");
	add_info("Check Type",$statusinfo[8]);
	add_info("Checks Enabled",$nagios->yesno($statusinfo[9]));
	add_info("Accepting Passive Checks",$nagios->yesno($statusinfo[10]));
	add_info("Event Handlers Enabled",$nagios->yesno($statusinfo[11]));
	add_info("Last State Change",$nagios->datetime($statusinfo[12]));
	add_info("Problem Acknowledged",$nagios->yesno($statusinfo[13]));
	add_info("Last Hard State",$nagios->datetime($statusinfo[14]));
	add_info("Time OK",$statusinfo[15]);
	add_info("Time Unknown",$statusinfo[16]);
	add_info("Time Warning",$statusinfo[17]);
	add_info("Time Critical",$statusinfo[18]);
	add_info("Last Notification Time",$nagios->datetime($statusinfo[19]));
	add_info("Current Notification Number",$statusinfo[20]);
	add_info("Notifications Enabled",$nagios->yesno($statusinfo[21]));
	add_info("Latency",$statusinfo[22]);
	add_info("Execution Time",$statusinfo[23]);
	add_info("Flap Detection Enabled",$nagios->yesno($statusinfo[24]));
	add_info("Service Is Flapping",$nagios->yesno($statusinfo[25]));
	add_info("Percent State Change",$statusinfo[26]);
	add_info("Scheduled Downtime Depth",$statusinfo[27]);
	add_info("Failure Prediction Enabled",$nagios->yesno($statusinfo[28]));
	add_info("Process Performance Date",$nagios->yesno($statusinfo[29]));
	add_info("Obsess Over Service",$nagios->yesno($statusinfo[30]));

	$blacksmith->assign("host_name",$statusinfo[1]);
	$blacksmith->assign("service_name",$statusinfo[2]);
        $blacksmith->assign("info_array",$info_array);
	$blacksmith->display("extinfo-svc.tpl");
}


$blacksmith->display("nagios-footer.tpl");

?>
