<?php

/*
 * Nagios PHP Interface: status.php
 * 2003-2004 Eldad Zack
 *
 * TODO: replace hardcoding style/status
 * TODO: audio alarms is commented out
 * TODO: add service and host filter apropriate to the contactgroups

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

$nagios->print_header("Current Network Status",true);

#
# Read status file
#

$status = file ($nagios->statusfile);

for ($x=0; $x<=6; $x++)
{
	$host['count'][$x]=0;
	$service['count'][$x]=0;
}

$service_array = array();
$host_array = array();

#
# Filter 
#

#TODO: add here service and host filter apropriate to the contactgroups

$filter_host = "/".$_GET['host']."/";
$filter_service = "/".$_GET['service']."/";

#
# Filter status
#

$myself = $_SERVER['PHP_SELF'];

# 5 bit selector
$filter_bitmap = (int)$_GET['serviceStatus'] & 31;

$filter_service_status = "";
if ($filter_bitmap & 1) { $filter_service_status .= "OK|"; }
if ($filter_bitmap & 2) { $filter_service_status .= "WARNING|"; }
if ($filter_bitmap & 4) { $filter_service_status .= "CRITICAL|"; }
if ($filter_bitmap & 8) { $filter_service_status .= "UNKNOWN|"; }
if ($filter_bitmap & 16) { $filter_service_status .= "PENDING|"; }
$filter_service_status="/".$filter_service_status."DUMMY/";

if ($filter_bitmap == 0 )
{
	$filter_bitmap = (int)$_GET['hostStatus'] & 15;
}
else
{
	$filter_bitmap = 0;
}

$filter_host_status = "";
if ($filter_bitmap & 1) { $filter_host_status .= "UP|"; }
if ($filter_bitmap & 2) { $filter_host_status .= "DOWN|"; }
if ($filter_bitmap & 4) { $filter_host_status .= "UNREACHABLE|"; }
if ($filter_bitmap & 8) { $filter_host_status .= "PENDING|"; }
$filter_host_status="/".$filter_host_status."DUMMY/";

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		### push every service into an array, later to be popped and displayed.

		$service_name = $field[2];
		if (!preg_match($filter_service,$service_name)) continue;

		$host_name = $field[1];
		if (!preg_match($filter_host,$host_name)) continue;

		## filter state
		$state = $field[3];
		if (preg_match($filter_service_status,$state)) continue;

		$attempt = $field[4];

		## Construct info

		$active_checks = $field[9];
		$passive_checks = $field[10];
		$problem_ack = $field[13];
		$notifications_enabled = $field[21];
		$service_flapping = $field[25];

		$stats = "";
		if (!$active_checks)		$stats .= '[a]';
		if (!$passive_checks)		$stats .= '[p]';
		if ($problem_ack)		$stats .= '[!]';
		if (!$notifications_enabled)	$stats .= '[N]';
		if ($service_flapping)		$stats .= '[F]';

		$info = $field[31];

		if (($last_check = $field[6])==0) $last_check = "Never";
		else $last_check = date("d/m/Y H:i:s",$last_check);

		if (($duration = $field[12])==0) $duration = "(Not Checked)";
		else $duration = $nagios->duration(time()-$duration);

		$service_array_element["host_name"]=$host_name;
		$service_array_element["service_name"]=$service_name;
		$service_array_element["status"]=$state;
		$service_array_element["attempt"]=$attempt;
		$service_array_element["last_check"]=$last_check;
		$service_array_element["duration"]=$duration;
		$service_array_element["info"]=$info;
		$service_array_element["stats"]=$stats;

		#The service counter array is 0 for OK, 1 for WARNING, 2 for CRITICAL and 3 for UNKNOWN (same as plugin return codes)
		#In addition, 4 for PENDING.

		if (preg_match("/OK/",$state))
		{
			$service['count'][0]++;
			$service_array_element["styleid"]="statusok";
		}
		elseif (preg_match("/WARNING/",$state))
		{
			$service['count'][1]++;
			$service_array_element["styleid"]="statusyel";
		}
		elseif (preg_match("/CRITICAL/",$state))
		{
			$service['count'][2]++;
			$service_array_element["styleid"]="statusred";
		}
		elseif (preg_match("/UNKNOWN/",$state))
		{
			$service['count'][3]++;
			$service_array_element["styleid"]="statusyel";
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$service['count'][4]++;
			$service_array_element["styleid"]="statuspale";
		}
		else
		{
			$service_array_element["styleid"]="statusnull";
		}
	
		array_push($service_array,$service_array_element);

	}
	elseif (preg_match("/HOST/",$type))
	{
		$host_name = $field[1];
		if (!preg_match($filter_host,$host_name)) continue;

		$state = $field[2];
		if (preg_match($filter_host_status,$state)) continue;

		$info = $field[20];
		$last_check = date("d-m-Y H:i:s",$field[3]);
		$duration = $nagios->duration(time()-$field[4]);

		$host_array_element['status'] = $state;
		$host_array_element['host_name'] = $host_name;
		$host_array_element['info'] = $info;
		$host_array_element['last_check'] = $last_check;
		$host_array_element['duration'] = $duration;

		#Host counter array: 0 for UP, 1 for DOWN, 2 for UNREACHABLE, 3 for PENDING

		if (preg_match("/UP/",$state))
		{
			$host['count'][0]++;
			$host_array_element['styleid']="statuspale";
		}
		elseif (preg_match("/DOWN/",$state))
		{
			$host['count'][1]++;
			$host_array_element['styleid']="statusred";
		}
		elseif (preg_match("/UNREACHABLE/",$state))
		{
			$host['count'][2]++;
			$host_array_element['styleid']="statusyel";
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$host['count'][3]++;
			$host_array_element['styleid']="statuspale";
		}
		else
		{
			$host_array_elemnt['styleid']="statusnull";
		}

		$host_array[$host_name]=$host_array_element;

	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$date = date("D M d H:i:s Y T",$reg[1]);
	}
}


#Infobox

$blacksmith->assign("date",$date);
$blacksmith->assign("username",$nagios->username);
$blacksmith->assign("refresh_rate",$nagios->config['refresh_rate']);

#Host/service status distribution

$host['color'][0] = "ok";
$host['color'][1] = "red";
$host['color'][2] = "red";
$host['color'][3] = "pale";
$host['color'][4] = "ok";
$host['color'][5] = "red";

$service['color'][0] = "ok";
$service['color'][1] = "yel";
$service['color'][2] = "red";
$service['color'][3] = "yel";
$service['color'][4] = "pale";
$service['color'][5] = "ok";
$service['color'][6] = "red";

# Totals
for ($x=0; $x<4; $x++)
{
	$host['count'][4] += $host['count'][$x];
}

for ($x=0; $x<5; $x++)
{
        $service['count'][5] += $service['count'][$x];
}

# Problems
$host['count'][5] = $host['count'][1] + $host['count'][2];
$service['count'][6] = $service['count'][1] + $service['count'][2] + $service['count'][3];

# Colors
# TODO: Change color of TOTAL to match state (aok = green, only warnings = yellow, also critical = red)
for ($x=0; $x<=5; $x++)
{
	if ($host['count'][$x] == 0)
	{
		$host['color'][$x] = 'null';
	}
}

for ($x=0; $x<=6; $x++)
{
        if ($service['count'][$x] == 0)
        {
                $service['color'][$x] = 'null';
        }
}

#
# Show me the money
#

$blacksmith->assign("service",$service);
$blacksmith->assign("host",$host);
$blacksmith->display("status.tpl");

#
# Format Display
#

$format = $_GET['format'];

if ($format==1)			// Host Style
{ 
	$blacksmith->assign("host_array",$host_array);
	$blacksmith->display("status-host.tpl");
}
else				// Default style is Service Listing
{
	$blacksmith->assign("host_array",$host_array);
	$blacksmith->assign("service_array",$service_array);
	$blacksmith->display("status-service.tpl");	
}

/* Alarms are disabled for now

if ($alarm > 0)
{
	if ($alarm == 1) { $alarmfile = $this->config['alarm_critial']; }
	if ($alarm == 2) { $alarmfile = $this->config['alarm_warning']; }

	print "<embed src=alarm/$alarmfile HIDDEN=TRUE AUTOSTART=TRUE>";
}

*/

$blacksmith->display("nagios-footer.tpl");

?>