<?php

/*
 * Nagios PHP Interface: tac.php
 * 2003-2004 Eldad Zack
 *
 * TODO: be more like tac.cgi

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP script init error. (tac.php)");
}

$status = file ($nagios->statusfile);

for ($x=0; $x<=4; $x++)
{
	$host['count'][$x]=0;
	$service['count'][$x]=0;
}

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		$globalstat['svc']['notifications_enabled'] += $field[21];
		$globalstat['svc']['activechecks_enabled'] += $field[9];
		$globalstat['svc']['passivechecks_enabled'] += $field[10];
		$globalstat['svc']['eventhandlers_enabled'] += $field[11];
		$globalstat['svc']['flapdetection_enabled'] += $field[24];
		$globalstat['svc']['failureprediction_enabled'] += $field[28];
		$globalstat['svc']['performancedata_enabled'] += $field[29];

		$state = $field[3];
		#The service counter array is 0 for OK, 1 for WARNING, 2 for CRITICAL and 3 for UNKNOWN (same as plugin return codes)
		#In addition, 4 for PENDING.

		if (preg_match("/OK/",$state))
		{
			$service['count'][0]++;
		}
		elseif (preg_match("/WARNING/",$state))
		{
			$service['count'][1]++;
		}
		elseif (preg_match("/CRITICAL/",$state))
		{
			$service['count'][2]++;
		}
		elseif (preg_match("/UNKNOWN/",$state))
		{
			$service['count'][3]++;
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$service['count'][4]++;
		}
		else
		{
			print "Parsing error (service state unmatched)";
		}
	}
	elseif (preg_match("/HOST/",$type))
	{
		$globalstat['host']['notifications_enabled'] += $field[11];
		$globalstat['host']['activechecks_enabled'] += $field[13];
		$globalstat['host']['passivechecks_enabled'] = -1;
		$globalstat['host']['eventhandlers_enabled'] += $field[12];
		$globalstat['host']['flapdetection_enabled'] += $field[14];
		$globalstat['host']['failureprediction_enabled'] += $field[18];
		#$globalstat['host']['performancedata_enabled'] += $field[9];
		$globalstat['host']['performancedata_enabled'] = -1;

		$state = $field[2];

		#Host counter array: 0 for UP, 1 for DOWN, 2 for UNREACHABLE, 3 for PENDING

		if (preg_match("/UP/",$state))
		{
			$host['count'][0]++;
		}
		elseif (preg_match("/DOWN/",$state))
		{
			$host['count'][1]++;
		}
		elseif (preg_match("/UNREACHABLE/",$state))
		{
			$host['count'][2]++;
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$host['count'][3]++;
		}
		else
		{
			print "Parsing error (host state unmatched)";
		}
	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$field = explode(";",$line);

		$globalstat['var']['date'] = date("D M d H:i:s Y T",$reg[1]);
		$globalstat['var']['notifications_enabled'] = $field[6];
		$globalstat['var']['activechecks_enabled'] = $field[7];
		$globalstat['var']['passivechecks_enabled'] = $field[8];
		$globalstat['var']['eventhandlers_enabled'] = $field[9];
		$globalstat['var']['obsess_enabled'] = $field[10];
		$globalstat['var']['flapdetection_enabled'] = $field[11];
		$globalstat['var']['failureprediction_enabled'] = $field[12];
		$globalstat['var']['performancedata_enabled'] = $field[13];
	}

}

$host['title'][0] = "Up";
$host['title'][1] = "Down";
$host['title'][2] = "Unreachable";
$host['title'][3] = "Pending";
$host['title'][4] = "Total";
$service['title'][0] = "Up";
$service['title'][1] = "Warning";
$service['title'][2] = "Critical";
$service['title'][3] = "Unknown";
$service['title'][4] = "Pending";
$service['title'][5] = "Total";


$host['color'][0] = "ok";
$host['color'][1] = "red";
$host['color'][2] = "red";
$host['color'][3] = "pale";
$host['color'][4] = "ok";
$service['color'][0] = "ok";
$service['color'][1] = "yel";
$service['color'][2] = "red";
$service['color'][3] = "yel";
$service['color'][4] = "pale";
$service['color'][5] = "ok";

for ($i=0; $i<5; $i++)
{
	$service['count'][5] += $service['count'][$i];
	if ($service['count'][$i] == 0)
	{
		 $service['color'][$i] = "null";
	}
}

for ($i=0; $i<4; $i++)
{
	$host['count'][4] += $host['count'][$i];
	if ($host['count'][$i] == 0)
	{
		$host['color'][$i] = "null";
	}
}

$globalstat['name']['notifications_enabled'] = 'Notifications Enabled';
$globalstat['name']['activechecks_enabled'] = 'Active Checks Enabled';
$globalstat['name']['passivechecks_enabled'] = 'Passive Checks Enabled';
$globalstat['name']['eventhandlers_enabled'] = 'Event Handlers Enabled';
$globalstat['name']['flapdetection_enabled'] = 'Flap Detection Enabled';
$globalstat['name']['performancedata_enabled'] = 'Performance Data Collection Enabled';


foreach(array_keys($globalstat['name']) as $key)
{
	$globalstat['global'][$key] = $nagios->yesno($globalstat['var'][$key]);
}

#
# Show me the money
#

$nagios->print_header("Tactical Network Overview",true);

# Infobox
$blacksmith->assign("date",$globalstat['var']['date']);
$blacksmith->assign("username",$nagios->username);
$blacksmith->assign("refresh_rate",$nagios->config['refresh_rate']);

# TAC
$blacksmith->assign("host",$host);
$blacksmith->assign("service",$service);
$blacksmith->assign("globalstat",$globalstat);
$blacksmith->display("tac.tpl");

$blacksmith->display("nagios-footer.tpl");

?>



