<?php

/*
 * Blacksmith
 * Simple Authentication and Configuration Framework
 * 2003-2004 Eldad Zack

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#
# Configuration
#

$blacksmith_config = "/home/httpd/var/blacksmith.cfg";

require_once('Auth/Auth.php');
require_once('Smarty/Smarty.class.php');

class Blacksmith extends Smarty
{
	var $config;
	var $auth;
	var $username;

	function Blacksmith($config_file,$private,$login)
	{
		$this->Smarty();

		if (!is_readable($config_file))
		{
			$this->error("Configuration file not found.");
			exit();
		}

		$this->parseconfig($config_file);

		$this->basedir($this->config['basedir']);

		$this->auth_init($login);
		
		if ($private)
		{
			$this->check_perm();
		}
		
	}

	function parseconfig($config_file)
	{
		$config = file ($config_file);

		foreach ($config as $line)				
		{
			if (preg_match("/^#|^$|^ *$/",$line))
                        {
                                continue;
                        }

                        preg_match("/^([A-Za-z_]*) *= *(.*) */",$line,$match);

                        $this->config[$match[1]]=$match[2];
		}
	}

	function auth_init($login)
	{
		$this->auth = new Auth("File",$this->config['passwd']);
		$this->auth->setShowLogin(false);
		$this->auth->start();

		if (!$this->auth->getAuth())
		{
			if ($login)
			{
				$this->login();
			}
		}
		else
		{
			$this->username=$this->auth->getUsername();
		}
	}

	function basedir($basedir)
	{
		$this->template_dir = $basedir."templates/";
		$this->compile_dir = $basedir."templates_c/";
		$this->config_dir = $basedir."configs/";
		$this->cache_dir = $basedir."cache/";
	}

	function error($errmsg)
	{
		$this->assign('errmsg',$errmsg);
		$this->display('error.tpl');
		exit();
	}

	function login()
	{
		$this->assign("phpself",$_SERVER['PHPSELF']);
		$this->display('login.tpl');
		exit();
	}

	function check_perm()
	{
		$uri = $_SERVER["REQUEST_URI"];
		$perm = $this->config['userperm_'.$this->username];

		if (!preg_match($perm,$uri))
		{
			$this->error('You do not have the proper permissions for this page.');
		}
	}

	function default_path()
	{
		return $this->config['userdefault_'.$this->username];
	}

	function logout()
	{
		$this->auth->logout();
		$this->display('logout.tpl');
	}
}

#
# Startup
#

if (!isset($blacksmith_private))
{
	$blacksmith_private = "1";
}

if (!isset($blacksmith_login))
{
	$blacksmith_login = "1";
}

$blacksmith = new Blacksmith($blacksmith_config,$blacksmith_private,$blacksmith_login);

?>