#!/bin/sh

FileSystemSpace() {
#  err_str="ERROR FS:"
  err_str=""
  OUT_TXT=""
  OK=0
  xok=0
  while read datos
  do
    set -A campos `echo $datos | awk '{print $1,$2,$3}'`
    temp=${campos[0]}
    megas=${campos[1]}
    musado=${campos[2]}
    (( musado = $megas - $musado ))
    porcentage=`echo $temp | cut -f1 -d %`
    fs_name=`echo $temp | cut -f2 -d %`
    excluido=0
    i=0
    j=0
    while (( $i < ${#param_fse[@]} )) 
    do
      fses=`echo ${param_fse[$i]} | cut -f1 -d " "`
      if [ "$fses" == "$fs_name" ]
      then
         excluido=1
         j=$i
         i=10000
      else
         (( i = $i + 1 ))
      fi
    done
    if [ $excluido == 0 ] 
    then
      i=0
      while (( $i < ${#param_fs[@]} ))
      do
       set -A param_v `echo ${param_fs[$i]} | awk '{print $1,$2,$3,$4}'`
       if [[ $megas -lt ${param_v[1]} && $megas -gt ${param_v[0]} && $porcentage -gt ${param_v[2]} ]]
       then
         xok=0
         err_str="$err_str ($fs_name $porcentage%)"
         if [ $porcentage > ${param_v[3]} ]
         then 
           xok=2
         else
           if [[ $porcentage -gt ${param_v[2]} ]] 
           then
             xok=1
           fi
         fi
         if [[ $OK -lt $xok ]]
         then
           OK=$xok
         fi
         i=10000
       fi
       (( i = $i + 1 ))
      done
    else
      xok=0
      set -A param_v `echo ${param_fse[$j]} | awk '{print $1,$2,$3}'`
      if [ $porcentage > ${param_v[2]} ]
      then
         xok=2
      else
         if [ $porcentage > ${param_v[1]} ] 
         then
           xok=1 
         fi
      fi
      if [[ $OK -lt $xok ]]
      then
       OK=$xok
       err_str="$err_str ($fs_name $porcentage%)"
      fi
    fi
  done < $TMPF
  OUT_TXT="FILE SYS: OK"
  if [[ $OK -gt 0 ]] 
  then
    if [[ $OK -eq 1 ]] 
    then
       OUT_TXT="ATENCION FS: $err_str"
    else
       OUT_TXT="CRITICO FS: $err_str"
    fi
  fi
}

#-------------------------------------------------------------
CommandLine() {
echo "$#
  Sintaxis : check_aix_fsystems.pl <param_file> | [-h]

  Ej: param_file:

# Se definen lineas de 2 tipos, fs y fse. Las fse tienen preferencia sobre
# las fs. El concepto que se aplica es el siguiente:
# 1. fse. Todo File System que contenga el string fse, el proceso solo
#         se fijara en el porcentage asignado si se sobrepasa se envia
#         un aviso.
#         Tambien es util para controlar Filesystems puntuales.
# 2. fs.  El resto de los Files System, se evaluaran dependiendo del tamao
#         del mismo. Para ello se define un rango en Mega Bytes y el
#         porcentage maximo ocupado antes de dar aviso, sobrepasado el
#         porcentage asignado, se envia un mensage.
fs 0 250 90 85
fs 251 500 85 80
fs 501 1000 90 85
fs 1001 10000 95 90
fs 10001 1000000 99 96
fse /apps/dlgx 99 97

"
}
#-------------------------------------------------------------

LeoParametros() {
  ifs=0
  ifse=0
  while read tfs resto
  do
     if [[ "$tfs" == "fs" ]]
     then
        param_fs[$ifs]=$resto
        (( ifs = $ifs + 1 ))
        okp=1
     else
       if [[ "$tfs" == "fse" ]]
       then
          param_fse[$ifse]=$resto
          (( ifse = $ifse + 1 ))
          okp=1
       fi
     fi
  done < $PFILE
}

#-----------------------------------------------------------
#-----------------------------------------------------------

OUT_TXT=""
OK=0
TMPF="/tmp/nag_fs.tmp"
CMDL=""

okp=1;
if [[ $# == 0 ]] 
then
   CommandLine
fi
PFILE=$1
LeoParametros

if [[ $okp == 1 ]]
then
  cmd="df -m | grep -i dev "
  OS=`uname`
  cok=9
  if [[ "$OS" == "Linux" ]]
  then
    cok=`df -m | grep -i dev | awk '{print \$5 \$6,\$2,\$4}' > $TMPF; echo $?`
  else 
    if [[ "$OS" == "AIX" ]]
    then
      cok=`df -m | grep -i dev | awk '{print \$4 \$7,\$2,\$3}' > $TMPF; echo $?`
    fi
  fi

  if [[ $cok == 0 ]]
  then
    FileSystemSpace
  else
    OUT_TXT="ERROR: en SO o apertura archivo temporal... $cok"
    OK=3
  fi
else
  OUT_TXT="ERROR: No Existe Archivo de Parametros $PFILE"
  OK=3
fi
echo $OUT_TXT
exit $OK

