<?php

/*
 * Nagios PHP Interface: extinfo.php
 * 2003-2004 Eldad Zack
 *
 * TODO: replace internal print()'ing with smarty
 * TODO: extinfo.cgi shows Nagios Proccess as default

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios php script init error.");
}

### TODO: extinfo.cgi shows Nagios Proccess as default.

### Clutter Prevention
function print_table_row($left,$right)
{
	print "<tr><td>$left</td><td>$right</td></tr>";
}


### $type
### 1 = host
### 2 = service 

$status = file ($nagios->statusfile);

if (isset($_GET['host']))
{
	if (isset($_GET['service']))
	{
		$scanstr = "SERVICE;".$_GET['host'].";".$_GET['service'].";";
		$title = "Extended Service Information";
		$type = 2;
	}
	else
	{
		$scanstr = "HOST;".$_GET['host'].";";
		$title = "Extended Host Information";
		$type = 1;
	}
}

if (!isset($scanstr))
{
	$nagios->print_error("No Host/Service Specified<br>");
}
else
{
	$scanstr = "/".$nagios->escape_preg($scanstr)."/";
	foreach ($status as $statusline)
	{
		if (preg_match($scanstr,$statusline))
		{
			$statusinfo=explode(";",$statusline);
			last;
		}
	}
}

if (!isset($statusinfo))
{
	$nagios->print_error("No Such Host/Service<br>");
}

$nagios->print_header($title,true);

print "<tr><td>";

if (preg_match("/\[([0-9]*)\] HOST/",$statusinfo[0],$reg))
### Host
{
	print "<center><table><tr><td><center>";
	print "Host<br><b>$statusinfo[1]<br>";
	print "<a href=status.php?host=$statusinfo[1]>(Services)</a><br>";

	print "<table>";
	print_table_row("Service Status",$statusinfo[2]);
	print_table_row("Plugin Output",$statusinfo[20]);
	print_table_row("Last Check Time",$nagios->datetime($statusinfo[3]));
	print_table_row("Last State Change",$nagios->datetime($statusinfo[4]));	
	print_table_row("Problem Acknowledged",$nagios->yesno($statusinfo[5]));
	print_table_row("Time UP",$statusinfo[6]);
	print_table_row("Time Down",$statusinfo[7]);
	print_table_row("Time Unreachable",$statusinfo[8]);
	print_table_row("Last Notification Time",$statusinfo[9]);
	print_table_row("Current Notification Number",$statusinfo[10]);
	print_table_row("Notifications Enabled",$nagios->yesno($statusinfo[11]));
	print_table_row("Event Handlers Enabled",$nagios->yesno($statusinfo[12]));
	print_table_row("Checks Enabled",$nagios->yesno($statusinfo[13]));
	print_table_row("Flap Detection Enabled",$nagios->yesno($statusinfo[14]));
	print_table_row("Host Is Flapping",$nagios->yesno($statusinfo[15]));
	print_table_row("Percent State Change",$statusinfo[16]);
	print_table_row("Scheduled Downtime Depth",$statusinfo[17]);
	print_table_row("Failure Prediction Enabled",$nagios->yesno($statusinfo[18]));
	print_table_row("Process Performance Date",$nagios->yesno($statusinfo[19]));
	

	print "</td></tr></table>";
	
}
else
### Service
{
	print "<center><table><tr><td><center>";
	print "Host<br><b>$statusinfo[1]</b><br>";
	print "<a href=status.php?host=$statusinfo[1]>(Services)</a><br>";
	print "<b>$statusinfo[2]</b><br>";
	
	print "<table>";
	print_table_row("Service Status",$statusinfo[3]);
	print_table_row("Plugin Output",$statusinfo[31]);
	print_table_row("Retry Number",$statusinfo[4]);
	print_table_row("State Type",$statusinfo[5]);
	print_table_row("Last Check Time",$nagios->datetime($statusinfo[6]));
	print_table_row("Next Check Time",$nagios->datetime($statusinfo[7]));
	print_table_row("Check Interval",(($statusinfo[7]-$statusinfo[6])/60)." Minute(s)");
	print_table_row("Check Type",$statusinfo[8]);
	print_table_row("Checks Enabled",$nagios->yesno($statusinfo[9]));
	print_table_row("Accepting Passive Checks",$nagios->yesno($statusinfo[10]));
	print_table_row("Event Handlers Enabled",$nagios->yesno($statusinfo[11]));
	print_table_row("Last State Change",$nagios->datetime($statusinfo[12]));
	print_table_row("Problem Acknowledged",$nagios->yesno($statusinfo[13]));
	print_table_row("Last Hard State",$nagios->datetime($statusinfo[14]));
	print_table_row("Time OK",$statusinfo[15]);
	print_table_row("Time Unknown",$statusinfo[16]);
	print_table_row("Time Warning",$statusinfo[17]);
	print_table_row("Time Critical",$statusinfo[18]);


	print_table_row("Last Notification Time",$nagios->datetime($statusinfo[19]));

	print_table_row("Current Notification Number",$statusinfo[20]);
	print_table_row("Notifications Enabled",$nagios->yesno($statusinfo[21]));
	print_table_row("Latency",$statusinfo[22]);
	print_table_row("Execution Time",$statusinfo[23]);
	print_table_row("Flap Detection Enabled",$nagios->yesno($statusinfo[24]));
	print_table_row("Service Is Flapping",$nagios->yesno($statusinfo[25]));
	print_table_row("Percent State Change",$statusinfo[26]);
	print_table_row("Scheduled Downtime Depth",$statusinfo[27]);
	print_table_row("Failure Prediction Enabled",$nagios->yesno($statusinfo[28]));
	print_table_row("Process Performance Date",$nagios->yesno($statusinfo[29]));
	print_table_row("Obsess Over Service",$nagios->yesno($statusinfo[30]));

	print "</table>";
	print "</td></tr></table>";	
}

$nagios->print_footer();

?>
