<?php

/*
 * Nagios PHP Interface: extinfo.php
 * 2003-2004 Eldad Zack
 *
 * TODO: replace internal print()'ing with smarty
 * TODO: allow showing other logs other than today's

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php") exit("Error.");


$nagios->print_header("Event Log",false);

$url=$_SERVER['PHP_SELF'];

print "<tr><td id=info>";
print "<form action=$url method=get>Search <input type=text name=match value=".$_GET['match']."></form>";
print "</td></tr>";

print "<tr><td><table id=white width=100% cellspacing=1 cellpadding=1 border=0>";

$lines = $_GET['lines'];
if (isset ($_GET['match']))
{
	$match = "/".$_GET['match']."/";
}
else
{
	$match = "/./";
}

if (isset ($_GET['log']))
{
	$log = file ($nagios->logarchive."/".$_GET['log']);
}
else
{
	$log = file ($nagios->logfile);
}

$log = array_reverse($log);

$i = 1;

foreach ($log as $line)
{
	$id="logpale";
	$img="info.png";

	if (!preg_match($match,$line)) continue;

	if (preg_match("/OK|UP/",$line)) 				{$id="logok"; $img="recovery.png";}
	elseif (preg_match("/WARNING/",$line))				{$id="logyel"; $img="warning.png";}
	elseif (preg_match("/CRITICAL|DOWN|UNREACHABLE/",$line))	{$id="logred"; $img="critical.png";}
	elseif (preg_match("/FLAPPING.*STOPPED/",$line))		{$id="logflapstop"; $img="warning.png";}
	elseif (preg_match("/FLAPPING.*STARTED/",$line))		{$id="logflapstart"; $img="recovery.png";}

	preg_match("/^\[([0-9]+)\] (.*)/",$line,$reg);

	print "<tr><td id=logpale nowrap>".date("d/m/Y H:i:s",$reg[1])."</td>";
	$line = $reg[2];

	print "<td id=white><img src=images/$img></td><td id=$id>$line</td></tr>";

	if (($lines != 0) && ($i >= $lines)) break;

	$i++;
}


print "</table>";


$nagios->print_footer();

?>
