<?php

/*
 * Nagios PHP Interface: status.php
 * 2003-2004 Eldad Zack
 *
 * TODO: replace hardcoding style/status
 * TODO: replace internal print()'ing with smarty
 * TODO: audio alarms is commented out
 * TODO: add service and host filter apropriate to the contactgroups
 * TODO: Drawing host/service status distribution code is ugly

 LICENSE:
  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios PHP initalization error.");
}

$nagios->print_header("Current Network Status",true);

#
# Read status file
#

$status = file ($nagios->statusfile);

for ($x=0; $x<=4; $x++)
{
	$host[$x]=0;
	$service[$x]=0;
}

$service_array = array();
$host_array = array();

#
# Filter 
#

### TODO: add here service and host filter apropriate to the contactgroups

$filter_host = "/".$_GET['host']."/";
$filter_service = "/".$_GET['service']."/";

### filter status 

$myself = $_SERVER['PHP_SELF'];

# 5 bit selector
$filter_bitmap = (int)$_GET['serviceStatus'] & 31;

$filter_service_status = "";
if ($filter_bitmap & 1) { $filter_service_status .= "OK|"; }
if ($filter_bitmap & 2) { $filter_service_status .= "WARNING|"; }
if ($filter_bitmap & 4) { $filter_service_status .= "CRITICAL|"; }
if ($filter_bitmap & 8) { $filter_service_status .= "UNKNOWN|"; }
if ($filter_bitmap & 16) { $filter_service_status .= "PENDING|"; }
$filter_service_status="/".$filter_service_status."DUMMY/";

if ($filter_bitmap == 0 )
{
	$filter_bitmap = (int)$_GET['hostStatus'] & 15;
}
else
{
	$filter_bitmap = 0;
}

$filter_host_status = "";
if ($filter_bitmap & 1) { $filter_host_status .= "UP|"; }
if ($filter_bitmap & 2) { $filter_host_status .= "DOWN|"; }
if ($filter_bitmap & 4) { $filter_host_status .= "UNREACHABLE|"; }
if ($filter_bitmap & 8) { $filter_host_status .= "PENDING|"; }
$filter_host_status="/".$filter_host_status."DUMMY/";

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		### push every service into an array, later to be popped and displayed.

		$service_name = $field[2];
		if (!preg_match($filter_service,$service_name)) continue;

		$host_name = $field[1];
		if (!preg_match($filter_host,$host_name)) continue;

		## filter state
		$state = $field[3];
		if (preg_match($filter_service_status,$state)) continue;

		$attempt = $field[4];

		## Construct info

		$active_checks = $field[9];
		$passive_checks = $field[10];
		$problem_ack = $field[13];
		$notifications_enabled = $field[21];
		$service_flapping = $field[25];

		$stats = "";
		if (!$active_checks)		$stats .= '[a]';
		if (!$passive_checks)		$stats .= '[p]';
		if ($problem_ack)		$stats .= '[!]';
		if (!$notifications_enabled)	$stats .= '[N]';
		if ($service_flapping)		$stats .= '[F]';

		$info = $field[31];

		if (($last_check = $field[6])==0) $last_check = "Never";
		else $last_check = date("d/m/Y H:i:s",$last_check);

		if (($duration = $field[12])==0) $duration = "(Not Checked)";
		else $duration = $nagios->duration(time()-$duration);

		### I'm not hard coding fields into the array since in Nagios 2.0 the status file format changes.

		$service_array_element["host_name"]=$host_name;
		$service_array_element["service_name"]=$service_name;
		$service_array_element["status"]=$state;
		$service_array_element["attempt"]=$attempt;
		$service_array_element["last_check"]=$last_check;
		$service_array_element["duration"]=$duration;
		$service_array_element["info"]=$info;
		$service_array_element["stats"]=$stats;

		#The service counter array is 0 for OK, 1 for WARNING, 2 for CRITICAL and 3 for UNKNOWN (same as plugin return codes)
		#In addition, 4 for PENDING.

		if (preg_match("/OK/",$state))
		{
			$service[0]++;
			$service_array_element["styleid"]="statusok";
		}
		elseif (preg_match("/WARNING/",$state))
		{
			$service[1]++;
			$service_array_element["styleid"]="statusyel";
		}
		elseif (preg_match("/CRITICAL/",$state))
		{
			$service[2]++;
			$service_array_element["styleid"]="statusred";
		}
		elseif (preg_match("/UNKNOWN/",$state))
		{
			$service[3]++;
			$service_array_element["styleid"]="statusyel";
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$service[4]++;
			$service_array_element["styleid"]="statuspale";
		}
		else
		{
			$service_array_element["styleid"]="statusnull";
		}
	
		array_push($service_array,$service_array_element);

	}
	elseif (preg_match("/HOST/",$type))
	{
		$host_name = $field[1];
		if (!preg_match($filter_host,$host_name)) continue;

		$state = $field[2];
		if (preg_match($filter_host_status,$state)) continue;

		$info = $field[20];
		$last_check = date("d-m-Y H:i:s",$field[3]);
		$duration = $nagios->duration(time()-$field[4]);

		$host_array_element['status'] = $state;
		$host_array_element['host_name'] = $host_name;
		$host_array_element['info'] = $info;
		$host_array_element['last_check'] = $last_check;
		$host_array_element['duration'] = $duration;

		#Host counter array: 0 for UP, 1 for DOWN, 2 for UNREACHABLE, 3 for PENDING

		if (preg_match("/UP/",$state))
		{
			$host[0]++;
			$host_array_element['styleid']="statuspale";
		}
		elseif (preg_match("/DOWN/",$state))
		{
			$host[1]++;
			$host_array_element['styleid']="statusred";
		}
		elseif (preg_match("/UNREACHABLE/",$state))
		{
			$host[2]++;
			$host_array_element['styleid']="statusyel";
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$host[3]++;
			$host_array_element['styleid']="statuspale";
		}
		else
		{
			$host_array_elemnt['styleid']="statusnull";
		}

		$host_array[$host_name]=$host_array_element;

	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$date = date("D M d H:i:s Y T",$reg[1]);
		print "<tr><td valign=top><table width=100% border=0 cellspacing=0 cellpadding=0><tr><td>";
		print "<table bgcolor=#000000 border=0 cellspacing=1 cellpadding=1><tr><td id=info>Last Update: <b>$date</b></td></tr>";
		print "</tr><td id=info>Logged in as <b>$nagios->username</b></td></tr>";
		print "</tr><td id=info>Update interval: <b>".$nagios->config['refresh_rate']." Seconds</b></td></tr></table></td>";
	}

}

#
# Draw host/service status distribution
#

print "<td><table align=right id=summary border=0 cellspacing=1 cellpadding=1>";
print "<tr><td id=title colspan=4>Hosts</td></tr><tr>";

if ($host[0] > 0) { $idtag="statusok"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?format=1&hostStatus=14>$host[0] Up</a></th>";

if ($host[1] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?format=1&hostStatus=13>$host[1] Down</a></th>";

if ($host[2] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }
print "<th id=$idtag colspan=2><a href=$myself?format=1&hostStatus=11>$host[2] Unreachable</a></th>";

print "</tr><tr>";

if ($host[3] > 0) { $idtag="statuspale"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?format=1&hostStatus=7>$host[3] Pending</a></th>";

if ($host[2]+$host[1] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }

$count = $host[1]+$host[2];
print "<th id=$idtag><a href=$myself?format=1&hostStatus=9>$count Problems</th>";

$count = $host[0]+$host[1]+$host[2]+$host[3];
print "<th id=statusnull><a href=$myself?format=1>$count Total</a></th>";

print "</tr></table></td><td><table align=right id=summary border=0 cellspacing=1 cellpadding=1>";
print "<tr><td id=title colspan=4>Services</td></tr><tr>";

if ($service[0] > 0) { $idtag="statusok"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?serviceStatus=30>$service[0] OK</a></th>";

if ($service[1] > 0) { $idtag="statusyel"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?serviceStatus=29>$service[1] Warning</a></th>";

if ($service[2] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?serviceStatus=27>$service[2] Critical</a></th>";

if ($service[3] > 0) { $idtag="statusyel"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?serviceStatus=23>$service[3] Unknown</a></th>";

print "</tr><tr>";

if ($service[4] > 0) { $idtag="statuspale"; }
else { $idtag="statusnull"; }
print "<th id=$idtag><a href=$myself?serviceStatus=15>$service[4] Pending</a></th>";

if ($service[1]+$service[2]+$service[3] > 0)
{
        if ($service[2] > 0)	{ $idtag="statusred"; $alarm=2; }
        else			{ $idtag="statusyel"; $alarm=1; }
}
else { $idtag="statusnull"; $alarm=0; }

$count = $service[1]+$service[2]+$service[3];
print "<th id=$idtag colspan=2><a href=$myself?serviceStatus=17>$count Problems</a></th>";

$count = $service[0]+$service[1]+$service[2]+$service[3]+$service[4];
print "<th id=statusnull><a href=$myself>$count Total</a></th>";
 
print "</tr></table>";
print "</table></td></tr></table></td>";

#
# Top End
#

print "</tr><tr><td><br><br>";

#
# Format Display
#

$format = $_GET['format'];

if ($format==1)
{ // Host Style

	print "<center><b>Host Status Details</td></tr>";
	print "<tr><table width=100% cellspacing=1 cellpadding=1 id=white><tr><td id=title>Host</td>";
	print "<td id=title>Status</td>";
	print "<td id=title>Last Check</td>";
	print "<td id=title>Duration</td>";
	print "<td id=title>Information</td>";
	print "</tr>";

	foreach ($host_array as $element)
	{
		$styleidstatus = $element['styleid'];
		$status = $element['status'];
		if ($status!="UP")
		{
			$styleid = $styleidstatus;
		}
		else
		{
			$styleid = "statuspale";
			$styleidstatus = "statusok";
		}
		
		print "<tr>";
		$host_name=$element['host_name'];
		print "<td id=$styleid><a href=\"extinfo.php?host=$host_name\">$host_name</td>";
		print "<td id=$styleidstatus>".$element['status']."</td>";
		print "<td id=$styleid>".$element['last_check']."</td>";
		print "<td id=$styleid>".$element['duration']."</td>";
		print "<td id=$styleid>".$element['info']."</td>";
		print "</tr>";

	}

}
else // Default style is Service Listing
{

	print "<center><b>Service Status Details</td></tr>";
	print "<tr><table width=100% cellspacing=1 cellpadding=1 id=white><tr><td id=title>Host</td>";
	print "<td id=title>Service</td>";
	print "<td id=title>Status</td>";
	print "<td id=title>Last Check</td>";
	print "<td id=title>Duration</td>";
	print "<td id=title>Attempt</td>";
	print "<td id=title>Information</td>";
	print "</tr>";

	$host_name_last = "";

	$tdheight=0;

	foreach ($service_array as $element)
	{
		$styleidstatus = $element['styleid'];
		$status = $element['status'];
		if ($status!="OK")
		{
			$styleid = $styleidstatus;
		}
		else
		{
			$styleid = "statuspale";
		}

		print "<tr>";

		$host_name = $element['host_name'];

		if ($host_name==$host_name_last)
		{
			print "<td></td>";
		}
		else
		{
			print "</tr>";
			if ($tdheight>0)
			{
				print "<tr><td height=$tdheight></td></tr>";
			}
			else
			{
				$tdheight=4;
			}
			print "<tr><td id=".$host_array[$host_name]['styleid']."><a href=\"extinfo.php?host=$host_name\">$host_name</td>";
			$host_name_last = $host_name;
		}
		$service=$element['service_name'];
		$stats=$element['stats'];

		print "<td id=$styleid nowrap><table width=100% border=0 cellspacing=0 cellpadding=0><tr><td><a href=\"extinfo.php?host=$host_name&service=";
		### allow using & in URLs
		print preg_replace("/\&/","%26",$service);
		print "\">$service</a></td><td align=right>$stats</td></tr></table></td>";

		print "<td id=$styleidstatus nowrap>".$element['status']."</td>";
		print "<td id=$styleid nowrap>".$element['last_check']."</td>";
		print "<td id=$styleid nowrap>".$element['duration']."</td>";
		print "<td id=$styleid nowrap>".$element['attempt']."</td>";
		print "<td id=$styleid>".$element['info']."</td>";
		print "</tr>";
	}
}

print "</table>";

if ($alarm > 0)
{
	if ($alarm == 1) { $alarmfile = $this->config['alarm_critial']; }
	if ($alarm == 2) { $alarmfile = $this->config['alarm_warning']; }

#	print "<embed src=alarm/$alarmfile HIDDEN=TRUE AUTOSTART=TRUE>";
}

$nagios->print_footer();

?>
