<?php

/*
 * Nagios PHP Interface: tac.php
 * 2003-2004 Eldad Zack
 *
 * TODO: replace internal print()'ing with smarty
 * TODO: be more like tac.cgi

 LICENSE:

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

if (!include "nagios.inc.php")
{
	exit("Nagios php script init error.");
}

$nagios->print_header("Tactical Network Overview",true);

$status = file ($nagios->statusfile);

for ($x=0; $x<=4; $x++)
{
	$host[$x]=0;
	$service[$x]=0;
}

foreach ($status as $line)
{
	$field = explode(";",$line);

	$type = $field[0];

	if (preg_match("/SERVICE/",$type))
	{
		$servicestat['notifications_enabled'] += $field[21];
                $servicestat['activechecks_enabled'] += $field[9];
                $servicestat['passivechecks_enabled'] += $field[10];
                $servicestat['eventhandlers_enabled'] += $field[11];
                $servicestat['flapdetection_enabled'] += $field[24];
                $servicestat['failureprediction_enabled'] += $field[28];
                $servicestat['performancedata_enabled'] += $field[29];

		$state = $field[3];
		#The service counter array is 0 for OK, 1 for WARNING, 2 for CRITICAL and 3 for UNKNOWN (same as plugin return codes)
		#In addition, 4 for PENDING.

		if (preg_match("/OK/",$state))
		{
			$service[0]++;
		}
		elseif (preg_match("/WARNING/",$state))
		{
			$service[1]++;
		}
		elseif (preg_match("/CRITICAL/",$state))
		{
			$service[2]++;
		}
		elseif (preg_match("/UNKNOWN/",$state))
		{
			$service[3]++;
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$service[4]++;
		}
		else
		{
			print "Parsing error (service state unmatched)";
		}
	}
	elseif (preg_match("/HOST/",$type))
	{

		$hoststat['notifications_enabled'] += $field[11];
                $hoststat['activechecks_enabled'] += $field[13];
                $hoststat['passivechecks_enabled'] = "-1";
                $hoststat['eventhandlers_enabled'] += $field[12];
                $hoststat['flapdetection_enabled'] += $field[14];
                $hoststat['failureprediction_enabled'] += $field[18];
                #$hoststat['performancedata_enabled'] += $field[9];
		$hoststat['performancedata_enabled'] = "-1";

		$state = $field[2];

		#Host counter array: 0 for UP, 1 for DOWN, 2 for UNREACHABLE, 3 for PENDING

		if (preg_match("/UP/",$state))
		{
			$host[0]++;
		}
		elseif (preg_match("/DOWN/",$state))
		{
			$host[1]++;
		}
		elseif (preg_match("/UNREACHABLE/",$state))
		{
			$host[2]++;
		}
		elseif (preg_match("/PENDING/",$state))
		{
			$host[3]++;
		}
		else
		{
			print "Parsing error (host state unmatched)";
		}
	}
	elseif (preg_match("/\[([0-9]+)\].*PROGRAM/",$line,$reg))
	{
		$field = explode(";",$line);

		$date = date("D M d H:i:s Y T",$reg[1]);
		print "<tr><td><table bgcolor=#000000 border=0 cellspacing=1 cellpadding=1><tr><td id=info>Last Update: <b>$date</b></td></tr>";
		print "</tr><td id=info>Logged in as <b>$nagios->username</b></td></tr>";
		print "</tr><td id=info>Update interval: <b>".$nagios->config['refresh_rate']." Seconds</b></td></tr></table></td>";

		$globalstat['notifications_enabled'] = $field[6];
		$globalstat['activechecks_enabled'] = $field[7];
		$globalstat['passivechecks_enabled'] = $field[8];
		$globalstat['eventhandlers_enabled'] = $field[9];
		$globalstat['obsess_enabled'] = $field[10];
		$globalstat['flapdetection_enabled'] = $field[11];
		$globalstat['failureprediction_enabled'] = $field[12];
		$globalstat['performancedata_enabled'] = $field[13];
	}

}

print "<tr><td><br><br><br><br><table bgcolor=#000000 border=0 cellspacing=1 cellpadding=1>";
print "<tr><td id=title colspan=4>Hosts</td></tr><tr>";

if ($host[0] > 0) { $idtag="statusok"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$host[0] Up</td>";

if ($host[1] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$host[1] Down</td>";

if ($host[2] > 0) { $idtag="statusyel"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$host[2] Unreachable</td>";

if ($host[3] > 0) { $idtag="statuspale"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$host[3] Pending</td>";

print "</td></tr></table><br><br><br><br><table bgcolor=#000000 border=0 cellspacing=1 cellpadding=1>";
print "<tr><td id=title colspan=5>Services</td></tr><tr>";

if ($service[0] > 0) { $idtag="statusok"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$service[0] OK</td>";

if ($service[1] > 0) { $idtag="statusyel"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$service[1] Warning</td>";

if ($service[2] > 0) { $idtag="statusred"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$service[2] Critical</td>";

if ($service[3] > 0) { $idtag="statusyel"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$service[3] Unknown</td>";

if ($service[4] > 0) { $idtag="statuspale"; }
else { $idtag="statusnull"; }
print "<th id=$idtag width=100>$service[4] Pending</td>";
print "</table>";

$service_count = $service[0]+$service[1]+$service[2]+$service[3]+$service[4];
$host_count = $host[0]+$host[1]+$host[2]+$host[3];

print "<br><br><br>\n<table bgcolor=#000000 border=0 cellspacing=1 cellpadding=1><tr>";
print "<td id=title>Nagios States</td><th id=title>Global</td><th id=title>Services</td><th id=title>Hosts</td></tr>";

$stats = array('notifications_enabled','activechecks_enabled','passivechecks_enabled','eventhandlers_enabled',
		'flapdetection_enabled','performancedata_enabled');
$stattitle = array('Notifications Enabled','Active Checks Enabled','Passive Checks Enabled','Event Handlers Enabled',
		'Flap Detection Enabled','Performance Data Collection Enabled');

for ($i=0; $i<count($stats); $i++)
{
	$statname = $stats[$i];

	print "\n<tr><td id=info>".$stattitle[$i]."</td>";
	print $nagios->yesnotd($globalstat[$statname]);

	$count = $service_count - $servicestat[$statname];
	if ($count > 0)
	{
		print "<td id=statusred>$count Services Disabled</td>";
	}
	else
	{
		print "<td id=statusok>All Services Enabled</td>";
	}

	if ($hoststat[$statname] < 0)
	{
		print "<td id=info></td>";
	}
	else
	{
                $count = $host_count - $hoststat[$statname];

		if ($count > 0)
	        {
			print "<td id=statusred>$count Hosts Disabled</td>";
	        }
	        else
	        {
			print "<td id=statusok>All Hosts Enabled</td>";
	        }

	}

	print "</tr>";
}

$nagios->print_footer();

?>



